/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeReservedInstancesOfferingsRequestMarshaller
implements Marshaller<Request<DescribeReservedInstancesOfferingsRequest>, DescribeReservedInstancesOfferingsRequest> {
    public Request<DescribeReservedInstancesOfferingsRequest> marshall(DescribeReservedInstancesOfferingsRequest describeReservedInstancesOfferingsRequest) {
        if (describeReservedInstancesOfferingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeReservedInstancesOfferingsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeReservedInstancesOfferings");
        request.addParameter("Version", "2015-04-15");
        List<String> reservedInstancesOfferingIdsList = describeReservedInstancesOfferingsRequest.getReservedInstancesOfferingIds();
        int reservedInstancesOfferingIdsListIndex = 1;
        for (String reservedInstancesOfferingIdsListValue : reservedInstancesOfferingIdsList) {
            if (reservedInstancesOfferingIdsListValue != null) {
                request.addParameter("ReservedInstancesOfferingId." + reservedInstancesOfferingIdsListIndex, StringUtils.fromString((String)reservedInstancesOfferingIdsListValue));
            }
            ++reservedInstancesOfferingIdsListIndex;
        }
        if (describeReservedInstancesOfferingsRequest.getInstanceType() != null) {
            request.addParameter("InstanceType", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.getInstanceType()));
        }
        if (describeReservedInstancesOfferingsRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.getAvailabilityZone()));
        }
        if (describeReservedInstancesOfferingsRequest.getProductDescription() != null) {
            request.addParameter("ProductDescription", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.getProductDescription()));
        }
        List<Filter> filtersList = describeReservedInstancesOfferingsRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        if (describeReservedInstancesOfferingsRequest.getInstanceTenancy() != null) {
            request.addParameter("InstanceTenancy", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.getInstanceTenancy()));
        }
        if (describeReservedInstancesOfferingsRequest.getOfferingType() != null) {
            request.addParameter("OfferingType", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.getOfferingType()));
        }
        if (describeReservedInstancesOfferingsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.getNextToken()));
        }
        if (describeReservedInstancesOfferingsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeReservedInstancesOfferingsRequest.getMaxResults()));
        }
        if (describeReservedInstancesOfferingsRequest.isIncludeMarketplace() != null) {
            request.addParameter("IncludeMarketplace", StringUtils.fromBoolean((Boolean)describeReservedInstancesOfferingsRequest.isIncludeMarketplace()));
        }
        if (describeReservedInstancesOfferingsRequest.getMinDuration() != null) {
            request.addParameter("MinDuration", StringUtils.fromLong((Long)describeReservedInstancesOfferingsRequest.getMinDuration()));
        }
        if (describeReservedInstancesOfferingsRequest.getMaxDuration() != null) {
            request.addParameter("MaxDuration", StringUtils.fromLong((Long)describeReservedInstancesOfferingsRequest.getMaxDuration()));
        }
        if (describeReservedInstancesOfferingsRequest.getMaxInstanceCount() != null) {
            request.addParameter("MaxInstanceCount", StringUtils.fromInteger((Integer)describeReservedInstancesOfferingsRequest.getMaxInstanceCount()));
        }
        return request;
    }
}

