/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeMovingAddressesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeMovingAddressesRequestMarshaller
implements Marshaller<Request<DescribeMovingAddressesRequest>, DescribeMovingAddressesRequest> {
    public Request<DescribeMovingAddressesRequest> marshall(DescribeMovingAddressesRequest describeMovingAddressesRequest) {
        if (describeMovingAddressesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeMovingAddressesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeMovingAddresses");
        request.addParameter("Version", "2015-04-15");
        List<String> publicIpsList = describeMovingAddressesRequest.getPublicIps();
        int publicIpsListIndex = 1;
        for (String publicIpsListValue : publicIpsList) {
            if (publicIpsListValue != null) {
                request.addParameter("PublicIp." + publicIpsListIndex, StringUtils.fromString((String)publicIpsListValue));
            }
            ++publicIpsListIndex;
        }
        if (describeMovingAddressesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeMovingAddressesRequest.getNextToken()));
        }
        List<Filter> filtersList = describeMovingAddressesRequest.getFilters();
        int filtersListIndex = 1;
        for (Filter filtersListValue : filtersList) {
            Filter filterMember = filtersListValue;
            if (filterMember != null) {
                if (filterMember.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filterMember.getName()));
                }
                List<String> valuesList = filterMember.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
            ++filtersListIndex;
        }
        if (describeMovingAddressesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeMovingAddressesRequest.getMaxResults()));
        }
        return request;
    }
}

