/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.databasemigrationservice.AWSDatabaseMigrationService;
import com.amazonaws.services.databasemigrationservice.model.DescribeEndpointsRequest;
import com.amazonaws.services.databasemigrationservice.model.DescribeReplicationInstancesRequest;
import com.amazonaws.services.databasemigrationservice.model.DescribeReplicationTasksRequest;
import com.amazonaws.services.databasemigrationservice.model.TestConnectionRequest;
import com.amazonaws.services.databasemigrationservice.waiters.DescribeEndpointsFunction;
import com.amazonaws.services.databasemigrationservice.waiters.DescribeReplicationInstancesFunction;
import com.amazonaws.services.databasemigrationservice.waiters.DescribeReplicationTasksFunction;
import com.amazonaws.services.databasemigrationservice.waiters.EndpointDeleted;
import com.amazonaws.services.databasemigrationservice.waiters.ReplicationInstanceAvailable;
import com.amazonaws.services.databasemigrationservice.waiters.ReplicationInstanceDeleted;
import com.amazonaws.services.databasemigrationservice.waiters.ReplicationTaskDeleted;
import com.amazonaws.services.databasemigrationservice.waiters.ReplicationTaskReady;
import com.amazonaws.services.databasemigrationservice.waiters.ReplicationTaskRunning;
import com.amazonaws.services.databasemigrationservice.waiters.ReplicationTaskStopped;
import com.amazonaws.services.databasemigrationservice.waiters.TestConnectionFunction;
import com.amazonaws.services.databasemigrationservice.waiters.TestConnectionSucceeds;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AWSDatabaseMigrationServiceWaiters {
    private final AWSDatabaseMigrationService client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AWSDatabaseMigrationServiceWaiters(AWSDatabaseMigrationService client) {
        this.client = client;
    }

    public Waiter<TestConnectionRequest> testConnectionSucceeds() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new TestConnectionFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new TestConnectionSucceeds.IsSuccessfulMatcher(), new TestConnectionSucceeds.IsFailedMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeReplicationInstancesRequest> replicationInstanceAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeReplicationInstancesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ReplicationInstanceAvailable.IsAvailableMatcher(), new ReplicationInstanceAvailable.IsDeletingMatcher(), new ReplicationInstanceAvailable.IsIncompatiblecredentialsMatcher(), new ReplicationInstanceAvailable.IsIncompatiblenetworkMatcher(), new ReplicationInstanceAvailable.IsInaccessibleencryptioncredentialsMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeReplicationTasksRequest> replicationTaskReady() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeReplicationTasksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ReplicationTaskReady.IsReadyMatcher(), new ReplicationTaskReady.IsStartingMatcher(), new ReplicationTaskReady.IsRunningMatcher(), new ReplicationTaskReady.IsStoppingMatcher(), new ReplicationTaskReady.IsStoppedMatcher(), new ReplicationTaskReady.IsFailedMatcher(), new ReplicationTaskReady.IsModifyingMatcher(), new ReplicationTaskReady.IsTestingMatcher(), new ReplicationTaskReady.IsDeletingMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeEndpointsRequest> endpointDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeEndpointsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new EndpointDeleted.IsResourceNotFoundFaultMatcher(), new EndpointDeleted.IsActiveMatcher(), new EndpointDeleted.IsCreatingMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeReplicationTasksRequest> replicationTaskDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeReplicationTasksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ReplicationTaskDeleted.IsReadyMatcher(), new ReplicationTaskDeleted.IsCreatingMatcher(), new ReplicationTaskDeleted.IsStoppedMatcher(), new ReplicationTaskDeleted.IsRunningMatcher(), new ReplicationTaskDeleted.IsFailedMatcher(), new ReplicationTaskDeleted.IsResourceNotFoundFaultMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeReplicationTasksRequest> replicationTaskStopped() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeReplicationTasksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ReplicationTaskStopped.IsStoppedMatcher(), new ReplicationTaskStopped.IsReadyMatcher(), new ReplicationTaskStopped.IsCreatingMatcher(), new ReplicationTaskStopped.IsStartingMatcher(), new ReplicationTaskStopped.IsRunningMatcher(), new ReplicationTaskStopped.IsFailedMatcher(), new ReplicationTaskStopped.IsModifyingMatcher(), new ReplicationTaskStopped.IsTestingMatcher(), new ReplicationTaskStopped.IsDeletingMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeReplicationTasksRequest> replicationTaskRunning() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeReplicationTasksFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ReplicationTaskRunning.IsRunningMatcher(), new ReplicationTaskRunning.IsReadyMatcher(), new ReplicationTaskRunning.IsCreatingMatcher(), new ReplicationTaskRunning.IsStoppingMatcher(), new ReplicationTaskRunning.IsStoppedMatcher(), new ReplicationTaskRunning.IsFailedMatcher(), new ReplicationTaskRunning.IsModifyingMatcher(), new ReplicationTaskRunning.IsTestingMatcher(), new ReplicationTaskRunning.IsDeletingMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeReplicationInstancesRequest> replicationInstanceDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeReplicationInstancesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ReplicationInstanceDeleted.IsAvailableMatcher(), new ReplicationInstanceDeleted.IsResourceNotFoundFaultMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

