/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dlm.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dlm.model.EventTypeValues;
import com.amazonaws.services.dlm.model.transform.EventParametersMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EventParameters
implements Serializable,
Cloneable,
StructuredPojo {
    private String eventType;
    private List<String> snapshotOwner;
    private String descriptionRegex;

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getEventType() {
        return this.eventType;
    }

    public EventParameters withEventType(String eventType) {
        this.setEventType(eventType);
        return this;
    }

    public EventParameters withEventType(EventTypeValues eventType) {
        this.eventType = eventType.toString();
        return this;
    }

    public List<String> getSnapshotOwner() {
        return this.snapshotOwner;
    }

    public void setSnapshotOwner(Collection<String> snapshotOwner) {
        if (snapshotOwner == null) {
            this.snapshotOwner = null;
            return;
        }
        this.snapshotOwner = new ArrayList<String>(snapshotOwner);
    }

    public EventParameters withSnapshotOwner(String ... snapshotOwner) {
        if (this.snapshotOwner == null) {
            this.setSnapshotOwner(new ArrayList<String>(snapshotOwner.length));
        }
        for (String ele : snapshotOwner) {
            this.snapshotOwner.add(ele);
        }
        return this;
    }

    public EventParameters withSnapshotOwner(Collection<String> snapshotOwner) {
        this.setSnapshotOwner(snapshotOwner);
        return this;
    }

    public void setDescriptionRegex(String descriptionRegex) {
        this.descriptionRegex = descriptionRegex;
    }

    public String getDescriptionRegex() {
        return this.descriptionRegex;
    }

    public EventParameters withDescriptionRegex(String descriptionRegex) {
        this.setDescriptionRegex(descriptionRegex);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventType() != null) {
            sb.append("EventType: ").append(this.getEventType()).append(",");
        }
        if (this.getSnapshotOwner() != null) {
            sb.append("SnapshotOwner: ").append(this.getSnapshotOwner()).append(",");
        }
        if (this.getDescriptionRegex() != null) {
            sb.append("DescriptionRegex: ").append(this.getDescriptionRegex());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventParameters)) {
            return false;
        }
        EventParameters other = (EventParameters)obj;
        if (other.getEventType() == null ^ this.getEventType() == null) {
            return false;
        }
        if (other.getEventType() != null && !other.getEventType().equals(this.getEventType())) {
            return false;
        }
        if (other.getSnapshotOwner() == null ^ this.getSnapshotOwner() == null) {
            return false;
        }
        if (other.getSnapshotOwner() != null && !other.getSnapshotOwner().equals(this.getSnapshotOwner())) {
            return false;
        }
        if (other.getDescriptionRegex() == null ^ this.getDescriptionRegex() == null) {
            return false;
        }
        return other.getDescriptionRegex() == null || other.getDescriptionRegex().equals(this.getDescriptionRegex());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventType() == null ? 0 : this.getEventType().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshotOwner() == null ? 0 : this.getSnapshotOwner().hashCode());
        hashCode = 31 * hashCode + (this.getDescriptionRegex() == null ? 0 : this.getDescriptionRegex().hashCode());
        return hashCode;
    }

    public EventParameters clone() {
        try {
            return (EventParameters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

