/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.directory.model.Setting;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class UpdateSettingsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String directoryId;
    private SdkInternalList<Setting> settings;

    public void setDirectoryId(String directoryId) {
        this.directoryId = directoryId;
    }

    public String getDirectoryId() {
        return this.directoryId;
    }

    public UpdateSettingsRequest withDirectoryId(String directoryId) {
        this.setDirectoryId(directoryId);
        return this;
    }

    public List<Setting> getSettings() {
        if (this.settings == null) {
            this.settings = new SdkInternalList();
        }
        return this.settings;
    }

    public void setSettings(Collection<Setting> settings) {
        if (settings == null) {
            this.settings = null;
            return;
        }
        this.settings = new SdkInternalList(settings);
    }

    public UpdateSettingsRequest withSettings(Setting ... settings) {
        if (this.settings == null) {
            this.setSettings((Collection<Setting>)new SdkInternalList(settings.length));
        }
        for (Setting ele : settings) {
            this.settings.add((Object)ele);
        }
        return this;
    }

    public UpdateSettingsRequest withSettings(Collection<Setting> settings) {
        this.setSettings(settings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDirectoryId() != null) {
            sb.append("DirectoryId: ").append(this.getDirectoryId()).append(",");
        }
        if (this.getSettings() != null) {
            sb.append("Settings: ").append(this.getSettings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSettingsRequest)) {
            return false;
        }
        UpdateSettingsRequest other = (UpdateSettingsRequest)obj;
        if (other.getDirectoryId() == null ^ this.getDirectoryId() == null) {
            return false;
        }
        if (other.getDirectoryId() != null && !other.getDirectoryId().equals(this.getDirectoryId())) {
            return false;
        }
        if (other.getSettings() == null ^ this.getSettings() == null) {
            return false;
        }
        return other.getSettings() == null || other.getSettings().equals(this.getSettings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDirectoryId() == null ? 0 : this.getDirectoryId().hashCode());
        hashCode = 31 * hashCode + (this.getSettings() == null ? 0 : this.getSettings().hashCode());
        return hashCode;
    }

    public UpdateSettingsRequest clone() {
        return (UpdateSettingsRequest)super.clone();
    }
}

