/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directconnect.model.Connection;

public class ConnectionJsonMarshaller {
    private static ConnectionJsonMarshaller instance;

    public void marshall(Connection connection, StructuredJsonGenerator jsonGenerator) {
        if (connection == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (connection.getOwnerAccount() != null) {
                jsonGenerator.writeFieldName("ownerAccount").writeValue(connection.getOwnerAccount());
            }
            if (connection.getConnectionId() != null) {
                jsonGenerator.writeFieldName("connectionId").writeValue(connection.getConnectionId());
            }
            if (connection.getConnectionName() != null) {
                jsonGenerator.writeFieldName("connectionName").writeValue(connection.getConnectionName());
            }
            if (connection.getConnectionState() != null) {
                jsonGenerator.writeFieldName("connectionState").writeValue(connection.getConnectionState());
            }
            if (connection.getRegion() != null) {
                jsonGenerator.writeFieldName("region").writeValue(connection.getRegion());
            }
            if (connection.getLocation() != null) {
                jsonGenerator.writeFieldName("location").writeValue(connection.getLocation());
            }
            if (connection.getBandwidth() != null) {
                jsonGenerator.writeFieldName("bandwidth").writeValue(connection.getBandwidth());
            }
            if (connection.getVlan() != null) {
                jsonGenerator.writeFieldName("vlan").writeValue(connection.getVlan().intValue());
            }
            if (connection.getPartnerName() != null) {
                jsonGenerator.writeFieldName("partnerName").writeValue(connection.getPartnerName());
            }
            if (connection.getLoaIssueTime() != null) {
                jsonGenerator.writeFieldName("loaIssueTime").writeValue(connection.getLoaIssueTime());
            }
            if (connection.getLagId() != null) {
                jsonGenerator.writeFieldName("lagId").writeValue(connection.getLagId());
            }
            if (connection.getAwsDevice() != null) {
                jsonGenerator.writeFieldName("awsDevice").writeValue(connection.getAwsDevice());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ConnectionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ConnectionJsonMarshaller();
        }
        return instance;
    }
}

