/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.devicefarm.model.NetworkProfile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListNetworkProfilesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<NetworkProfile> networkProfiles;
    private String nextToken;

    public List<NetworkProfile> getNetworkProfiles() {
        return this.networkProfiles;
    }

    public void setNetworkProfiles(Collection<NetworkProfile> networkProfiles) {
        if (networkProfiles == null) {
            this.networkProfiles = null;
            return;
        }
        this.networkProfiles = new ArrayList<NetworkProfile>(networkProfiles);
    }

    public ListNetworkProfilesResult withNetworkProfiles(NetworkProfile ... networkProfiles) {
        if (this.networkProfiles == null) {
            this.setNetworkProfiles(new ArrayList<NetworkProfile>(networkProfiles.length));
        }
        for (NetworkProfile ele : networkProfiles) {
            this.networkProfiles.add(ele);
        }
        return this;
    }

    public ListNetworkProfilesResult withNetworkProfiles(Collection<NetworkProfile> networkProfiles) {
        this.setNetworkProfiles(networkProfiles);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListNetworkProfilesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNetworkProfiles() != null) {
            sb.append("NetworkProfiles: ").append(this.getNetworkProfiles()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNetworkProfilesResult)) {
            return false;
        }
        ListNetworkProfilesResult other = (ListNetworkProfilesResult)obj;
        if (other.getNetworkProfiles() == null ^ this.getNetworkProfiles() == null) {
            return false;
        }
        if (other.getNetworkProfiles() != null && !other.getNetworkProfiles().equals(this.getNetworkProfiles())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNetworkProfiles() == null ? 0 : this.getNetworkProfiles().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListNetworkProfilesResult clone() {
        try {
            return (ListNetworkProfilesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

