/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.detective;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.detective.AmazonDetectiveAsync;
import com.amazonaws.services.detective.AmazonDetectiveAsyncClientBuilder;
import com.amazonaws.services.detective.AmazonDetectiveClient;
import com.amazonaws.services.detective.model.AcceptInvitationRequest;
import com.amazonaws.services.detective.model.AcceptInvitationResult;
import com.amazonaws.services.detective.model.CreateGraphRequest;
import com.amazonaws.services.detective.model.CreateGraphResult;
import com.amazonaws.services.detective.model.CreateMembersRequest;
import com.amazonaws.services.detective.model.CreateMembersResult;
import com.amazonaws.services.detective.model.DeleteGraphRequest;
import com.amazonaws.services.detective.model.DeleteGraphResult;
import com.amazonaws.services.detective.model.DeleteMembersRequest;
import com.amazonaws.services.detective.model.DeleteMembersResult;
import com.amazonaws.services.detective.model.DescribeOrganizationConfigurationRequest;
import com.amazonaws.services.detective.model.DescribeOrganizationConfigurationResult;
import com.amazonaws.services.detective.model.DisableOrganizationAdminAccountRequest;
import com.amazonaws.services.detective.model.DisableOrganizationAdminAccountResult;
import com.amazonaws.services.detective.model.DisassociateMembershipRequest;
import com.amazonaws.services.detective.model.DisassociateMembershipResult;
import com.amazonaws.services.detective.model.EnableOrganizationAdminAccountRequest;
import com.amazonaws.services.detective.model.EnableOrganizationAdminAccountResult;
import com.amazonaws.services.detective.model.GetMembersRequest;
import com.amazonaws.services.detective.model.GetMembersResult;
import com.amazonaws.services.detective.model.ListGraphsRequest;
import com.amazonaws.services.detective.model.ListGraphsResult;
import com.amazonaws.services.detective.model.ListInvitationsRequest;
import com.amazonaws.services.detective.model.ListInvitationsResult;
import com.amazonaws.services.detective.model.ListMembersRequest;
import com.amazonaws.services.detective.model.ListMembersResult;
import com.amazonaws.services.detective.model.ListOrganizationAdminAccountsRequest;
import com.amazonaws.services.detective.model.ListOrganizationAdminAccountsResult;
import com.amazonaws.services.detective.model.ListTagsForResourceRequest;
import com.amazonaws.services.detective.model.ListTagsForResourceResult;
import com.amazonaws.services.detective.model.RejectInvitationRequest;
import com.amazonaws.services.detective.model.RejectInvitationResult;
import com.amazonaws.services.detective.model.StartMonitoringMemberRequest;
import com.amazonaws.services.detective.model.StartMonitoringMemberResult;
import com.amazonaws.services.detective.model.TagResourceRequest;
import com.amazonaws.services.detective.model.TagResourceResult;
import com.amazonaws.services.detective.model.UntagResourceRequest;
import com.amazonaws.services.detective.model.UntagResourceResult;
import com.amazonaws.services.detective.model.UpdateOrganizationConfigurationRequest;
import com.amazonaws.services.detective.model.UpdateOrganizationConfigurationResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonDetectiveAsyncClient
extends AmazonDetectiveClient
implements AmazonDetectiveAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonDetectiveAsyncClientBuilder asyncBuilder() {
        return AmazonDetectiveAsyncClientBuilder.standard();
    }

    AmazonDetectiveAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonDetectiveAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AcceptInvitationResult> acceptInvitationAsync(AcceptInvitationRequest request) {
        return this.acceptInvitationAsync(request, null);
    }

    @Override
    public Future<AcceptInvitationResult> acceptInvitationAsync(AcceptInvitationRequest request, final AsyncHandler<AcceptInvitationRequest, AcceptInvitationResult> asyncHandler) {
        final AcceptInvitationRequest finalRequest = (AcceptInvitationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AcceptInvitationResult>(){

            @Override
            public AcceptInvitationResult call() throws Exception {
                AcceptInvitationResult result = null;
                try {
                    result = AmazonDetectiveAsyncClient.this.executeAcceptInvitation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateGraphResult> createGraphAsync(CreateGraphRequest request) {
        return this.createGraphAsync(request, null);
    }

    @Override
    public Future<CreateGraphResult> createGraphAsync(CreateGraphRequest request, final AsyncHandler<CreateGraphRequest, CreateGraphResult> asyncHandler) {
        final CreateGraphRequest finalRequest = (CreateGraphRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateGraphResult>(){

            @Override
            public CreateGraphResult call() throws Exception {
                CreateGraphResult result = null;
                try {
                    result = AmazonDetectiveAsyncClient.this.executeCreateGraph(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateMembersResult> createMembersAsync(CreateMembersRequest request) {
        return this.createMembersAsync(request, null);
    }

    @Override
    public Future<CreateMembersResult> createMembersAsync(CreateMembersRequest request, final AsyncHandler<CreateMembersRequest, CreateMembersResult> asyncHandler) {
        final CreateMembersRequest finalRequest = (CreateMembersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateMembersResult>(){

            @Override
            public CreateMembersResult call() throws Exception {
                CreateMembersResult result = null;
                try {
                    result = AmazonDetectiveAsyncClient.this.executeCreateMembers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteGraphResult> deleteGraphAsync(DeleteGraphRequest request) {
        return this.deleteGraphAsync(request, null);
    }

    @Override
    public Future<DeleteGraphResult> deleteGraphAsync(DeleteGraphRequest request, final AsyncHandler<DeleteGraphRequest, DeleteGraphResult> asyncHandler) {
        final DeleteGraphRequest finalRequest = (DeleteGraphRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteGraphResult>(){

            @Override
            public DeleteGraphResult call() throws Exception {
                DeleteGraphResult result = null;
                try {
                    result = AmazonDetectiveAsyncClient.this.executeDeleteGraph(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMembersResult> deleteMembersAsync(DeleteMembersRequest request) {
        return this.deleteMembersAsync(request, null);
    }

    @Override
    public Future<DeleteMembersResult> deleteMembersAsync(DeleteMembersRequest request, final AsyncHandler<DeleteMembersRequest, DeleteMembersResult> asyncHandler) {
        final DeleteMembersRequest finalRequest = (DeleteMembersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteMembersResult>(){

            @Override
            public DeleteMembersResult call() throws Exception {
                DeleteMembersResult result = null;
                try {
                    result = AmazonDetectiveAsyncClient.this.executeDeleteMembers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeOrganizationConfigurationResult> describeOrganizationConfigurationAsync(DescribeOrganizationConfigurationRequest request) {
        return this.describeOrganizationConfigurationAsync(request, null);
    }

    @Override
    public Future<DescribeOrganizationConfigurationResult> describeOrganizationConfigurationAsync(DescribeOrganizationConfigurationRequest request, final AsyncHandler<DescribeOrganizationConfigurationRequest, DescribeOrganizationConfigurationResult> asyncHandler) {
        final DescribeOrganizationConfigurationRequest finalRequest = (DescribeOrganizationConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeOrganizationConfigurationResult>(){

            @Override
            public DescribeOrganizationConfigurationResult call() throws Exception {
                DescribeOrganizationConfigurationResult result = null;
                try {
                    result = AmazonDetectiveAsyncClient.this.executeDescribeOrganizationConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableOrganizationAdminAccountResult> disableOrganizationAdminAccountAsync(DisableOrganizationAdminAccountRequest request) {
        return this.disableOrganizationAdminAccountAsync(request, null);
    }

    @Override
    public Future<DisableOrganizationAdminAccountResult> disableOrganizationAdminAccountAsync(DisableOrganizationAdminAccountRequest request, final AsyncHandler<DisableOrganizationAdminAccountRequest, DisableOrganizationAdminAccountResult> asyncHandler) {
        final DisableOrganizationAdminAccountRequest finalRequest = (DisableOrganizationAdminAccountRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisableOrganizationAdminAccountResult>(){

            @Override
            public DisableOrganizationAdminAccountResult call() throws Exception {
                DisableOrganizationAdminAccountResult result = null;
                try {
                    result = AmazonDetectiveAsyncClient.this.executeDisableOrganizationAdminAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateMembershipResult> disassociateMembershipAsync(DisassociateMembershipRequest request) {
        return this.disassociateMembershipAsync(request, null);
    }

    @Override
    public Future<DisassociateMembershipResult> disassociateMembershipAsync(DisassociateMembershipRequest request, final AsyncHandler<DisassociateMembershipRequest, DisassociateMembershipResult> asyncHandler) {
        final DisassociateMembershipRequest finalRequest = (DisassociateMembershipRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateMembershipResult>(){

            @Override
            public DisassociateMembershipResult call() throws Exception {
                DisassociateMembershipResult result = null;
                try {
                    result = AmazonDetectiveAsyncClient.this.executeDisassociateMembership(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableOrganizationAdminAccountResult> enableOrganizationAdminAccountAsync(EnableOrganizationAdminAccountRequest request) {
        return this.enableOrganizationAdminAccountAsync(request, null);
    }

    @Override
    public Future<EnableOrganizationAdminAccountResult> enableOrganizationAdminAccountAsync(EnableOrganizationAdminAccountRequest request, final AsyncHandler<EnableOrganizationAdminAccountRequest, EnableOrganizationAdminAccountResult> asyncHandler) {
        final EnableOrganizationAdminAccountRequest finalRequest = (EnableOrganizationAdminAccountRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EnableOrganizationAdminAccountResult>(){

            @Override
            public EnableOrganizationAdminAccountResult call() throws Exception {
                EnableOrganizationAdminAccountResult result = null;
                try {
                    result = AmazonDetectiveAsyncClient.this.executeEnableOrganizationAdminAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMembersResult> getMembersAsync(GetMembersRequest request) {
        return this.getMembersAsync(request, null);
    }

    @Override
    public Future<GetMembersResult> getMembersAsync(GetMembersRequest request, final AsyncHandler<GetMembersRequest, GetMembersResult> asyncHandler) {
        final GetMembersRequest finalRequest = (GetMembersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMembersResult>(){

            @Override
            public GetMembersResult call() throws Exception {
                GetMembersResult result = null;
                try {
                    result = AmazonDetectiveAsyncClient.this.executeGetMembers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListGraphsResult> listGraphsAsync(ListGraphsRequest request) {
        return this.listGraphsAsync(request, null);
    }

    @Override
    public Future<ListGraphsResult> listGraphsAsync(ListGraphsRequest request, final AsyncHandler<ListGraphsRequest, ListGraphsResult> asyncHandler) {
        final ListGraphsRequest finalRequest = (ListGraphsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListGraphsResult>(){

            @Override
            public ListGraphsResult call() throws Exception {
                ListGraphsResult result = null;
                try {
                    result = AmazonDetectiveAsyncClient.this.executeListGraphs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListInvitationsResult> listInvitationsAsync(ListInvitationsRequest request) {
        return this.listInvitationsAsync(request, null);
    }

    @Override
    public Future<ListInvitationsResult> listInvitationsAsync(ListInvitationsRequest request, final AsyncHandler<ListInvitationsRequest, ListInvitationsResult> asyncHandler) {
        final ListInvitationsRequest finalRequest = (ListInvitationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListInvitationsResult>(){

            @Override
            public ListInvitationsResult call() throws Exception {
                ListInvitationsResult result = null;
                try {
                    result = AmazonDetectiveAsyncClient.this.executeListInvitations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMembersResult> listMembersAsync(ListMembersRequest request) {
        return this.listMembersAsync(request, null);
    }

    @Override
    public Future<ListMembersResult> listMembersAsync(ListMembersRequest request, final AsyncHandler<ListMembersRequest, ListMembersResult> asyncHandler) {
        final ListMembersRequest finalRequest = (ListMembersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListMembersResult>(){

            @Override
            public ListMembersResult call() throws Exception {
                ListMembersResult result = null;
                try {
                    result = AmazonDetectiveAsyncClient.this.executeListMembers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListOrganizationAdminAccountsResult> listOrganizationAdminAccountsAsync(ListOrganizationAdminAccountsRequest request) {
        return this.listOrganizationAdminAccountsAsync(request, null);
    }

    @Override
    public Future<ListOrganizationAdminAccountsResult> listOrganizationAdminAccountsAsync(ListOrganizationAdminAccountsRequest request, final AsyncHandler<ListOrganizationAdminAccountsRequest, ListOrganizationAdminAccountsResult> asyncHandler) {
        final ListOrganizationAdminAccountsRequest finalRequest = (ListOrganizationAdminAccountsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListOrganizationAdminAccountsResult>(){

            @Override
            public ListOrganizationAdminAccountsResult call() throws Exception {
                ListOrganizationAdminAccountsResult result = null;
                try {
                    result = AmazonDetectiveAsyncClient.this.executeListOrganizationAdminAccounts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonDetectiveAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RejectInvitationResult> rejectInvitationAsync(RejectInvitationRequest request) {
        return this.rejectInvitationAsync(request, null);
    }

    @Override
    public Future<RejectInvitationResult> rejectInvitationAsync(RejectInvitationRequest request, final AsyncHandler<RejectInvitationRequest, RejectInvitationResult> asyncHandler) {
        final RejectInvitationRequest finalRequest = (RejectInvitationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RejectInvitationResult>(){

            @Override
            public RejectInvitationResult call() throws Exception {
                RejectInvitationResult result = null;
                try {
                    result = AmazonDetectiveAsyncClient.this.executeRejectInvitation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartMonitoringMemberResult> startMonitoringMemberAsync(StartMonitoringMemberRequest request) {
        return this.startMonitoringMemberAsync(request, null);
    }

    @Override
    public Future<StartMonitoringMemberResult> startMonitoringMemberAsync(StartMonitoringMemberRequest request, final AsyncHandler<StartMonitoringMemberRequest, StartMonitoringMemberResult> asyncHandler) {
        final StartMonitoringMemberRequest finalRequest = (StartMonitoringMemberRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartMonitoringMemberResult>(){

            @Override
            public StartMonitoringMemberResult call() throws Exception {
                StartMonitoringMemberResult result = null;
                try {
                    result = AmazonDetectiveAsyncClient.this.executeStartMonitoringMember(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonDetectiveAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonDetectiveAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateOrganizationConfigurationResult> updateOrganizationConfigurationAsync(UpdateOrganizationConfigurationRequest request) {
        return this.updateOrganizationConfigurationAsync(request, null);
    }

    @Override
    public Future<UpdateOrganizationConfigurationResult> updateOrganizationConfigurationAsync(UpdateOrganizationConfigurationRequest request, final AsyncHandler<UpdateOrganizationConfigurationRequest, UpdateOrganizationConfigurationResult> asyncHandler) {
        final UpdateOrganizationConfigurationRequest finalRequest = (UpdateOrganizationConfigurationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateOrganizationConfigurationResult>(){

            @Override
            public UpdateOrganizationConfigurationResult call() throws Exception {
                UpdateOrganizationConfigurationResult result = null;
                try {
                    result = AmazonDetectiveAsyncClient.this.executeUpdateOrganizationConfiguration(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

