/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.detective;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.detective.AmazonDetective;
import com.amazonaws.services.detective.AmazonDetectiveClientBuilder;
import com.amazonaws.services.detective.model.AcceptInvitationRequest;
import com.amazonaws.services.detective.model.AcceptInvitationResult;
import com.amazonaws.services.detective.model.AmazonDetectiveException;
import com.amazonaws.services.detective.model.CreateGraphRequest;
import com.amazonaws.services.detective.model.CreateGraphResult;
import com.amazonaws.services.detective.model.CreateMembersRequest;
import com.amazonaws.services.detective.model.CreateMembersResult;
import com.amazonaws.services.detective.model.DeleteGraphRequest;
import com.amazonaws.services.detective.model.DeleteGraphResult;
import com.amazonaws.services.detective.model.DeleteMembersRequest;
import com.amazonaws.services.detective.model.DeleteMembersResult;
import com.amazonaws.services.detective.model.DisassociateMembershipRequest;
import com.amazonaws.services.detective.model.DisassociateMembershipResult;
import com.amazonaws.services.detective.model.GetMembersRequest;
import com.amazonaws.services.detective.model.GetMembersResult;
import com.amazonaws.services.detective.model.ListGraphsRequest;
import com.amazonaws.services.detective.model.ListGraphsResult;
import com.amazonaws.services.detective.model.ListInvitationsRequest;
import com.amazonaws.services.detective.model.ListInvitationsResult;
import com.amazonaws.services.detective.model.ListMembersRequest;
import com.amazonaws.services.detective.model.ListMembersResult;
import com.amazonaws.services.detective.model.RejectInvitationRequest;
import com.amazonaws.services.detective.model.RejectInvitationResult;
import com.amazonaws.services.detective.model.transform.AcceptInvitationRequestProtocolMarshaller;
import com.amazonaws.services.detective.model.transform.AcceptInvitationResultJsonUnmarshaller;
import com.amazonaws.services.detective.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.detective.model.transform.CreateGraphRequestProtocolMarshaller;
import com.amazonaws.services.detective.model.transform.CreateGraphResultJsonUnmarshaller;
import com.amazonaws.services.detective.model.transform.CreateMembersRequestProtocolMarshaller;
import com.amazonaws.services.detective.model.transform.CreateMembersResultJsonUnmarshaller;
import com.amazonaws.services.detective.model.transform.DeleteGraphRequestProtocolMarshaller;
import com.amazonaws.services.detective.model.transform.DeleteGraphResultJsonUnmarshaller;
import com.amazonaws.services.detective.model.transform.DeleteMembersRequestProtocolMarshaller;
import com.amazonaws.services.detective.model.transform.DeleteMembersResultJsonUnmarshaller;
import com.amazonaws.services.detective.model.transform.DisassociateMembershipRequestProtocolMarshaller;
import com.amazonaws.services.detective.model.transform.DisassociateMembershipResultJsonUnmarshaller;
import com.amazonaws.services.detective.model.transform.GetMembersRequestProtocolMarshaller;
import com.amazonaws.services.detective.model.transform.GetMembersResultJsonUnmarshaller;
import com.amazonaws.services.detective.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.detective.model.transform.ListGraphsRequestProtocolMarshaller;
import com.amazonaws.services.detective.model.transform.ListGraphsResultJsonUnmarshaller;
import com.amazonaws.services.detective.model.transform.ListInvitationsRequestProtocolMarshaller;
import com.amazonaws.services.detective.model.transform.ListInvitationsResultJsonUnmarshaller;
import com.amazonaws.services.detective.model.transform.ListMembersRequestProtocolMarshaller;
import com.amazonaws.services.detective.model.transform.ListMembersResultJsonUnmarshaller;
import com.amazonaws.services.detective.model.transform.RejectInvitationRequestProtocolMarshaller;
import com.amazonaws.services.detective.model.transform.RejectInvitationResultJsonUnmarshaller;
import com.amazonaws.services.detective.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.detective.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.detective.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonDetectiveClient
extends AmazonWebServiceClient
implements AmazonDetective {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonDetective.class);
    private static final String DEFAULT_SIGNING_NAME = "detective";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonDetectiveException.class));

    public static AmazonDetectiveClientBuilder builder() {
        return AmazonDetectiveClientBuilder.standard();
    }

    AmazonDetectiveClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonDetectiveClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("api.detective");
        this.setEndpoint("api.detective.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/detective/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/detective/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public AcceptInvitationResult acceptInvitation(AcceptInvitationRequest request) {
        request = (AcceptInvitationRequest)this.beforeClientExecution(request);
        return this.executeAcceptInvitation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final AcceptInvitationResult executeAcceptInvitation(AcceptInvitationRequest acceptInvitationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(acceptInvitationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AcceptInvitationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AcceptInvitationRequestProtocolMarshaller(protocolFactory).marshall((AcceptInvitationRequest)super.beforeMarshalling((AmazonWebServiceRequest)acceptInvitationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Detective");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"AcceptInvitation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new AcceptInvitationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            AcceptInvitationResult acceptInvitationResult = (AcceptInvitationResult)response.getAwsResponse();
            return acceptInvitationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateGraphResult createGraph(CreateGraphRequest request) {
        request = (CreateGraphRequest)this.beforeClientExecution(request);
        return this.executeCreateGraph(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateGraphResult executeCreateGraph(CreateGraphRequest createGraphRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createGraphRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateGraphRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateGraphRequestProtocolMarshaller(protocolFactory).marshall((CreateGraphRequest)super.beforeMarshalling((AmazonWebServiceRequest)createGraphRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Detective");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateGraph");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateGraphResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateGraphResult createGraphResult = (CreateGraphResult)response.getAwsResponse();
            return createGraphResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateMembersResult createMembers(CreateMembersRequest request) {
        request = (CreateMembersRequest)this.beforeClientExecution(request);
        return this.executeCreateMembers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateMembersResult executeCreateMembers(CreateMembersRequest createMembersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createMembersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateMembersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateMembersRequestProtocolMarshaller(protocolFactory).marshall((CreateMembersRequest)super.beforeMarshalling((AmazonWebServiceRequest)createMembersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Detective");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateMembers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateMembersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateMembersResult createMembersResult = (CreateMembersResult)response.getAwsResponse();
            return createMembersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteGraphResult deleteGraph(DeleteGraphRequest request) {
        request = (DeleteGraphRequest)this.beforeClientExecution(request);
        return this.executeDeleteGraph(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteGraphResult executeDeleteGraph(DeleteGraphRequest deleteGraphRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteGraphRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteGraphRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteGraphRequestProtocolMarshaller(protocolFactory).marshall((DeleteGraphRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteGraphRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Detective");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteGraph");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteGraphResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteGraphResult deleteGraphResult = (DeleteGraphResult)response.getAwsResponse();
            return deleteGraphResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteMembersResult deleteMembers(DeleteMembersRequest request) {
        request = (DeleteMembersRequest)this.beforeClientExecution(request);
        return this.executeDeleteMembers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteMembersResult executeDeleteMembers(DeleteMembersRequest deleteMembersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteMembersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteMembersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteMembersRequestProtocolMarshaller(protocolFactory).marshall((DeleteMembersRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteMembersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Detective");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteMembers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteMembersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteMembersResult deleteMembersResult = (DeleteMembersResult)response.getAwsResponse();
            return deleteMembersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisassociateMembershipResult disassociateMembership(DisassociateMembershipRequest request) {
        request = (DisassociateMembershipRequest)this.beforeClientExecution(request);
        return this.executeDisassociateMembership(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisassociateMembershipResult executeDisassociateMembership(DisassociateMembershipRequest disassociateMembershipRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disassociateMembershipRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisassociateMembershipRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisassociateMembershipRequestProtocolMarshaller(protocolFactory).marshall((DisassociateMembershipRequest)super.beforeMarshalling((AmazonWebServiceRequest)disassociateMembershipRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Detective");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisassociateMembership");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisassociateMembershipResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisassociateMembershipResult disassociateMembershipResult = (DisassociateMembershipResult)response.getAwsResponse();
            return disassociateMembershipResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetMembersResult getMembers(GetMembersRequest request) {
        request = (GetMembersRequest)this.beforeClientExecution(request);
        return this.executeGetMembers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetMembersResult executeGetMembers(GetMembersRequest getMembersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getMembersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetMembersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetMembersRequestProtocolMarshaller(protocolFactory).marshall((GetMembersRequest)super.beforeMarshalling((AmazonWebServiceRequest)getMembersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Detective");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetMembers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetMembersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetMembersResult getMembersResult = (GetMembersResult)response.getAwsResponse();
            return getMembersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListGraphsResult listGraphs(ListGraphsRequest request) {
        request = (ListGraphsRequest)this.beforeClientExecution(request);
        return this.executeListGraphs(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListGraphsResult executeListGraphs(ListGraphsRequest listGraphsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listGraphsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListGraphsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListGraphsRequestProtocolMarshaller(protocolFactory).marshall((ListGraphsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listGraphsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Detective");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListGraphs");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListGraphsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListGraphsResult listGraphsResult = (ListGraphsResult)response.getAwsResponse();
            return listGraphsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListInvitationsResult listInvitations(ListInvitationsRequest request) {
        request = (ListInvitationsRequest)this.beforeClientExecution(request);
        return this.executeListInvitations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListInvitationsResult executeListInvitations(ListInvitationsRequest listInvitationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listInvitationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListInvitationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListInvitationsRequestProtocolMarshaller(protocolFactory).marshall((ListInvitationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listInvitationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Detective");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListInvitations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListInvitationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListInvitationsResult listInvitationsResult = (ListInvitationsResult)response.getAwsResponse();
            return listInvitationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListMembersResult listMembers(ListMembersRequest request) {
        request = (ListMembersRequest)this.beforeClientExecution(request);
        return this.executeListMembers(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListMembersResult executeListMembers(ListMembersRequest listMembersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listMembersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListMembersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListMembersRequestProtocolMarshaller(protocolFactory).marshall((ListMembersRequest)super.beforeMarshalling((AmazonWebServiceRequest)listMembersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Detective");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListMembers");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListMembersResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListMembersResult listMembersResult = (ListMembersResult)response.getAwsResponse();
            return listMembersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RejectInvitationResult rejectInvitation(RejectInvitationRequest request) {
        request = (RejectInvitationRequest)this.beforeClientExecution(request);
        return this.executeRejectInvitation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RejectInvitationResult executeRejectInvitation(RejectInvitationRequest rejectInvitationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(rejectInvitationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RejectInvitationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RejectInvitationRequestProtocolMarshaller(protocolFactory).marshall((RejectInvitationRequest)super.beforeMarshalling((AmazonWebServiceRequest)rejectInvitationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Detective");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RejectInvitation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RejectInvitationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RejectInvitationResult rejectInvitationResult = (RejectInvitationResult)response.getAwsResponse();
            return rejectInvitationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }
}

