/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.deadline.model.SearchGroupedFilterExpressions;
import com.amazonaws.services.deadline.model.SearchSortExpression;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchTasksRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String farmId;
    private SearchGroupedFilterExpressions filterExpressions;
    private Integer itemOffset;
    private String jobId;
    private Integer pageSize;
    private List<String> queueIds;
    private List<SearchSortExpression> sortExpressions;

    public void setFarmId(String farmId) {
        this.farmId = farmId;
    }

    public String getFarmId() {
        return this.farmId;
    }

    public SearchTasksRequest withFarmId(String farmId) {
        this.setFarmId(farmId);
        return this;
    }

    public void setFilterExpressions(SearchGroupedFilterExpressions filterExpressions) {
        this.filterExpressions = filterExpressions;
    }

    public SearchGroupedFilterExpressions getFilterExpressions() {
        return this.filterExpressions;
    }

    public SearchTasksRequest withFilterExpressions(SearchGroupedFilterExpressions filterExpressions) {
        this.setFilterExpressions(filterExpressions);
        return this;
    }

    public void setItemOffset(Integer itemOffset) {
        this.itemOffset = itemOffset;
    }

    public Integer getItemOffset() {
        return this.itemOffset;
    }

    public SearchTasksRequest withItemOffset(Integer itemOffset) {
        this.setItemOffset(itemOffset);
        return this;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public SearchTasksRequest withJobId(String jobId) {
        this.setJobId(jobId);
        return this;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public SearchTasksRequest withPageSize(Integer pageSize) {
        this.setPageSize(pageSize);
        return this;
    }

    public List<String> getQueueIds() {
        return this.queueIds;
    }

    public void setQueueIds(Collection<String> queueIds) {
        if (queueIds == null) {
            this.queueIds = null;
            return;
        }
        this.queueIds = new ArrayList<String>(queueIds);
    }

    public SearchTasksRequest withQueueIds(String ... queueIds) {
        if (this.queueIds == null) {
            this.setQueueIds(new ArrayList<String>(queueIds.length));
        }
        for (String ele : queueIds) {
            this.queueIds.add(ele);
        }
        return this;
    }

    public SearchTasksRequest withQueueIds(Collection<String> queueIds) {
        this.setQueueIds(queueIds);
        return this;
    }

    public List<SearchSortExpression> getSortExpressions() {
        return this.sortExpressions;
    }

    public void setSortExpressions(Collection<SearchSortExpression> sortExpressions) {
        if (sortExpressions == null) {
            this.sortExpressions = null;
            return;
        }
        this.sortExpressions = new ArrayList<SearchSortExpression>(sortExpressions);
    }

    public SearchTasksRequest withSortExpressions(SearchSortExpression ... sortExpressions) {
        if (this.sortExpressions == null) {
            this.setSortExpressions(new ArrayList<SearchSortExpression>(sortExpressions.length));
        }
        for (SearchSortExpression ele : sortExpressions) {
            this.sortExpressions.add(ele);
        }
        return this;
    }

    public SearchTasksRequest withSortExpressions(Collection<SearchSortExpression> sortExpressions) {
        this.setSortExpressions(sortExpressions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFarmId() != null) {
            sb.append("FarmId: ").append(this.getFarmId()).append(",");
        }
        if (this.getFilterExpressions() != null) {
            sb.append("FilterExpressions: ").append(this.getFilterExpressions()).append(",");
        }
        if (this.getItemOffset() != null) {
            sb.append("ItemOffset: ").append(this.getItemOffset()).append(",");
        }
        if (this.getJobId() != null) {
            sb.append("JobId: ").append(this.getJobId()).append(",");
        }
        if (this.getPageSize() != null) {
            sb.append("PageSize: ").append(this.getPageSize()).append(",");
        }
        if (this.getQueueIds() != null) {
            sb.append("QueueIds: ").append(this.getQueueIds()).append(",");
        }
        if (this.getSortExpressions() != null) {
            sb.append("SortExpressions: ").append(this.getSortExpressions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTasksRequest)) {
            return false;
        }
        SearchTasksRequest other = (SearchTasksRequest)obj;
        if (other.getFarmId() == null ^ this.getFarmId() == null) {
            return false;
        }
        if (other.getFarmId() != null && !other.getFarmId().equals(this.getFarmId())) {
            return false;
        }
        if (other.getFilterExpressions() == null ^ this.getFilterExpressions() == null) {
            return false;
        }
        if (other.getFilterExpressions() != null && !other.getFilterExpressions().equals(this.getFilterExpressions())) {
            return false;
        }
        if (other.getItemOffset() == null ^ this.getItemOffset() == null) {
            return false;
        }
        if (other.getItemOffset() != null && !other.getItemOffset().equals(this.getItemOffset())) {
            return false;
        }
        if (other.getJobId() == null ^ this.getJobId() == null) {
            return false;
        }
        if (other.getJobId() != null && !other.getJobId().equals(this.getJobId())) {
            return false;
        }
        if (other.getPageSize() == null ^ this.getPageSize() == null) {
            return false;
        }
        if (other.getPageSize() != null && !other.getPageSize().equals(this.getPageSize())) {
            return false;
        }
        if (other.getQueueIds() == null ^ this.getQueueIds() == null) {
            return false;
        }
        if (other.getQueueIds() != null && !other.getQueueIds().equals(this.getQueueIds())) {
            return false;
        }
        if (other.getSortExpressions() == null ^ this.getSortExpressions() == null) {
            return false;
        }
        return other.getSortExpressions() == null || other.getSortExpressions().equals(this.getSortExpressions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFarmId() == null ? 0 : this.getFarmId().hashCode());
        hashCode = 31 * hashCode + (this.getFilterExpressions() == null ? 0 : this.getFilterExpressions().hashCode());
        hashCode = 31 * hashCode + (this.getItemOffset() == null ? 0 : this.getItemOffset().hashCode());
        hashCode = 31 * hashCode + (this.getJobId() == null ? 0 : this.getJobId().hashCode());
        hashCode = 31 * hashCode + (this.getPageSize() == null ? 0 : this.getPageSize().hashCode());
        hashCode = 31 * hashCode + (this.getQueueIds() == null ? 0 : this.getQueueIds().hashCode());
        hashCode = 31 * hashCode + (this.getSortExpressions() == null ? 0 : this.getSortExpressions().hashCode());
        return hashCode;
    }

    public SearchTasksRequest clone() {
        return (SearchTasksRequest)super.clone();
    }
}

