/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.deadline.model.AssignedSessionAction;
import com.amazonaws.services.deadline.model.LogConfiguration;
import com.amazonaws.services.deadline.model.transform.AssignedSessionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AssignedSession
implements Serializable,
Cloneable,
StructuredPojo {
    private String jobId;
    private LogConfiguration logConfiguration;
    private String queueId;
    private List<AssignedSessionAction> sessionActions;

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public AssignedSession withJobId(String jobId) {
        this.setJobId(jobId);
        return this;
    }

    public void setLogConfiguration(LogConfiguration logConfiguration) {
        this.logConfiguration = logConfiguration;
    }

    public LogConfiguration getLogConfiguration() {
        return this.logConfiguration;
    }

    public AssignedSession withLogConfiguration(LogConfiguration logConfiguration) {
        this.setLogConfiguration(logConfiguration);
        return this;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public String getQueueId() {
        return this.queueId;
    }

    public AssignedSession withQueueId(String queueId) {
        this.setQueueId(queueId);
        return this;
    }

    public List<AssignedSessionAction> getSessionActions() {
        return this.sessionActions;
    }

    public void setSessionActions(Collection<AssignedSessionAction> sessionActions) {
        if (sessionActions == null) {
            this.sessionActions = null;
            return;
        }
        this.sessionActions = new ArrayList<AssignedSessionAction>(sessionActions);
    }

    public AssignedSession withSessionActions(AssignedSessionAction ... sessionActions) {
        if (this.sessionActions == null) {
            this.setSessionActions(new ArrayList<AssignedSessionAction>(sessionActions.length));
        }
        for (AssignedSessionAction ele : sessionActions) {
            this.sessionActions.add(ele);
        }
        return this;
    }

    public AssignedSession withSessionActions(Collection<AssignedSessionAction> sessionActions) {
        this.setSessionActions(sessionActions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJobId() != null) {
            sb.append("JobId: ").append(this.getJobId()).append(",");
        }
        if (this.getLogConfiguration() != null) {
            sb.append("LogConfiguration: ").append(this.getLogConfiguration()).append(",");
        }
        if (this.getQueueId() != null) {
            sb.append("QueueId: ").append(this.getQueueId()).append(",");
        }
        if (this.getSessionActions() != null) {
            sb.append("SessionActions: ").append(this.getSessionActions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignedSession)) {
            return false;
        }
        AssignedSession other = (AssignedSession)obj;
        if (other.getJobId() == null ^ this.getJobId() == null) {
            return false;
        }
        if (other.getJobId() != null && !other.getJobId().equals(this.getJobId())) {
            return false;
        }
        if (other.getLogConfiguration() == null ^ this.getLogConfiguration() == null) {
            return false;
        }
        if (other.getLogConfiguration() != null && !other.getLogConfiguration().equals(this.getLogConfiguration())) {
            return false;
        }
        if (other.getQueueId() == null ^ this.getQueueId() == null) {
            return false;
        }
        if (other.getQueueId() != null && !other.getQueueId().equals(this.getQueueId())) {
            return false;
        }
        if (other.getSessionActions() == null ^ this.getSessionActions() == null) {
            return false;
        }
        return other.getSessionActions() == null || other.getSessionActions().equals(this.getSessionActions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJobId() == null ? 0 : this.getJobId().hashCode());
        hashCode = 31 * hashCode + (this.getLogConfiguration() == null ? 0 : this.getLogConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getQueueId() == null ? 0 : this.getQueueId().hashCode());
        hashCode = 31 * hashCode + (this.getSessionActions() == null ? 0 : this.getSessionActions().hashCode());
        return hashCode;
    }

    public AssignedSession clone() {
        try {
            return (AssignedSession)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AssignedSessionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

