/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.deadline.model.IpAddresses;
import java.util.List;

@SdkInternalApi
public class IpAddressesMarshaller {
    private static final MarshallingInfo<List> IPV4ADDRESSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ipV4Addresses").build();
    private static final MarshallingInfo<List> IPV6ADDRESSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ipV6Addresses").build();
    private static final IpAddressesMarshaller instance = new IpAddressesMarshaller();

    public static IpAddressesMarshaller getInstance() {
        return instance;
    }

    public void marshall(IpAddresses ipAddresses, ProtocolMarshaller protocolMarshaller) {
        if (ipAddresses == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(ipAddresses.getIpV4Addresses(), IPV4ADDRESSES_BINDING);
            protocolMarshaller.marshall(ipAddresses.getIpV6Addresses(), IPV6ADDRESSES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

