/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.deadline.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.deadline.model.FarmMember;

@SdkInternalApi
public class FarmMemberMarshaller {
    private static final MarshallingInfo<String> FARMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("farmId").build();
    private static final MarshallingInfo<String> IDENTITYSTOREID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("identityStoreId").build();
    private static final MarshallingInfo<String> MEMBERSHIPLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("membershipLevel").build();
    private static final MarshallingInfo<String> PRINCIPALID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("principalId").build();
    private static final MarshallingInfo<String> PRINCIPALTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("principalType").build();
    private static final FarmMemberMarshaller instance = new FarmMemberMarshaller();

    public static FarmMemberMarshaller getInstance() {
        return instance;
    }

    public void marshall(FarmMember farmMember, ProtocolMarshaller protocolMarshaller) {
        if (farmMember == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)farmMember.getFarmId(), FARMID_BINDING);
            protocolMarshaller.marshall((Object)farmMember.getIdentityStoreId(), IDENTITYSTOREID_BINDING);
            protocolMarshaller.marshall((Object)farmMember.getMembershipLevel(), MEMBERSHIPLEVEL_BINDING);
            protocolMarshaller.marshall((Object)farmMember.getPrincipalId(), PRINCIPALID_BINDING);
            protocolMarshaller.marshall((Object)farmMember.getPrincipalType(), PRINCIPALTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

