/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class EvaluateExpressionRequestMarshaller
implements Marshaller<Request<EvaluateExpressionRequest>, EvaluateExpressionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public EvaluateExpressionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<EvaluateExpressionRequest> marshall(EvaluateExpressionRequest evaluateExpressionRequest) {
        if (evaluateExpressionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)evaluateExpressionRequest, "DataPipeline");
        request.addHeader("X-Amz-Target", "DataPipeline.EvaluateExpression");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (evaluateExpressionRequest.getPipelineId() != null) {
                jsonGenerator.writeFieldName("pipelineId").writeValue(evaluateExpressionRequest.getPipelineId());
            }
            if (evaluateExpressionRequest.getObjectId() != null) {
                jsonGenerator.writeFieldName("objectId").writeValue(evaluateExpressionRequest.getObjectId());
            }
            if (evaluateExpressionRequest.getExpression() != null) {
                jsonGenerator.writeFieldName("expression").writeValue(evaluateExpressionRequest.getExpression());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

