/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.dataexchange.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.dataexchange.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * CreateS3DataAccessFromS3BucketRequestDetails JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateS3DataAccessFromS3BucketRequestDetailsJsonUnmarshaller implements
        Unmarshaller<CreateS3DataAccessFromS3BucketRequestDetails, JsonUnmarshallerContext> {

    public CreateS3DataAccessFromS3BucketRequestDetails unmarshall(JsonUnmarshallerContext context) throws Exception {
        CreateS3DataAccessFromS3BucketRequestDetails createS3DataAccessFromS3BucketRequestDetails = new CreateS3DataAccessFromS3BucketRequestDetails();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("AssetSource", targetDepth)) {
                    context.nextToken();
                    createS3DataAccessFromS3BucketRequestDetails.setAssetSource(S3DataAccessAssetSourceEntryJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("DataSetId", targetDepth)) {
                    context.nextToken();
                    createS3DataAccessFromS3BucketRequestDetails.setDataSetId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("RevisionId", targetDepth)) {
                    context.nextToken();
                    createS3DataAccessFromS3BucketRequestDetails.setRevisionId(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return createS3DataAccessFromS3BucketRequestDetails;
    }

    private static CreateS3DataAccessFromS3BucketRequestDetailsJsonUnmarshaller instance;

    public static CreateS3DataAccessFromS3BucketRequestDetailsJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new CreateS3DataAccessFromS3BucketRequestDetailsJsonUnmarshaller();
        return instance;
    }
}
