/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dataexchange.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dataexchange.model.AssetDestinationEntry;
import com.amazonaws.services.dataexchange.model.transform.ExportAssetsToS3RequestDetailsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExportAssetsToS3RequestDetails
implements Serializable,
Cloneable,
StructuredPojo {
    private List<AssetDestinationEntry> assetDestinations;
    private String dataSetId;
    private String revisionId;

    public List<AssetDestinationEntry> getAssetDestinations() {
        return this.assetDestinations;
    }

    public void setAssetDestinations(Collection<AssetDestinationEntry> assetDestinations) {
        if (assetDestinations == null) {
            this.assetDestinations = null;
            return;
        }
        this.assetDestinations = new ArrayList<AssetDestinationEntry>(assetDestinations);
    }

    public ExportAssetsToS3RequestDetails withAssetDestinations(AssetDestinationEntry ... assetDestinations) {
        if (this.assetDestinations == null) {
            this.setAssetDestinations(new ArrayList<AssetDestinationEntry>(assetDestinations.length));
        }
        for (AssetDestinationEntry ele : assetDestinations) {
            this.assetDestinations.add(ele);
        }
        return this;
    }

    public ExportAssetsToS3RequestDetails withAssetDestinations(Collection<AssetDestinationEntry> assetDestinations) {
        this.setAssetDestinations(assetDestinations);
        return this;
    }

    public void setDataSetId(String dataSetId) {
        this.dataSetId = dataSetId;
    }

    public String getDataSetId() {
        return this.dataSetId;
    }

    public ExportAssetsToS3RequestDetails withDataSetId(String dataSetId) {
        this.setDataSetId(dataSetId);
        return this;
    }

    public void setRevisionId(String revisionId) {
        this.revisionId = revisionId;
    }

    public String getRevisionId() {
        return this.revisionId;
    }

    public ExportAssetsToS3RequestDetails withRevisionId(String revisionId) {
        this.setRevisionId(revisionId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAssetDestinations() != null) {
            sb.append("AssetDestinations: ").append(this.getAssetDestinations()).append(",");
        }
        if (this.getDataSetId() != null) {
            sb.append("DataSetId: ").append(this.getDataSetId()).append(",");
        }
        if (this.getRevisionId() != null) {
            sb.append("RevisionId: ").append(this.getRevisionId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportAssetsToS3RequestDetails)) {
            return false;
        }
        ExportAssetsToS3RequestDetails other = (ExportAssetsToS3RequestDetails)obj;
        if (other.getAssetDestinations() == null ^ this.getAssetDestinations() == null) {
            return false;
        }
        if (other.getAssetDestinations() != null && !other.getAssetDestinations().equals(this.getAssetDestinations())) {
            return false;
        }
        if (other.getDataSetId() == null ^ this.getDataSetId() == null) {
            return false;
        }
        if (other.getDataSetId() != null && !other.getDataSetId().equals(this.getDataSetId())) {
            return false;
        }
        if (other.getRevisionId() == null ^ this.getRevisionId() == null) {
            return false;
        }
        return other.getRevisionId() == null || other.getRevisionId().equals(this.getRevisionId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAssetDestinations() == null ? 0 : this.getAssetDestinations().hashCode());
        hashCode = 31 * hashCode + (this.getDataSetId() == null ? 0 : this.getDataSetId().hashCode());
        hashCode = 31 * hashCode + (this.getRevisionId() == null ? 0 : this.getRevisionId().hashCode());
        return hashCode;
    }

    public ExportAssetsToS3RequestDetails clone() {
        try {
            return (ExportAssetsToS3RequestDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ExportAssetsToS3RequestDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

