/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.customerprofiles.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.customerprofiles.model.Batch;
import com.amazonaws.services.customerprofiles.model.FlowDefinition;
import com.amazonaws.services.customerprofiles.model.transform.AppflowIntegrationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AppflowIntegration
implements Serializable,
Cloneable,
StructuredPojo {
    private FlowDefinition flowDefinition;
    private List<Batch> batches;

    public void setFlowDefinition(FlowDefinition flowDefinition) {
        this.flowDefinition = flowDefinition;
    }

    public FlowDefinition getFlowDefinition() {
        return this.flowDefinition;
    }

    public AppflowIntegration withFlowDefinition(FlowDefinition flowDefinition) {
        this.setFlowDefinition(flowDefinition);
        return this;
    }

    public List<Batch> getBatches() {
        return this.batches;
    }

    public void setBatches(Collection<Batch> batches) {
        if (batches == null) {
            this.batches = null;
            return;
        }
        this.batches = new ArrayList<Batch>(batches);
    }

    public AppflowIntegration withBatches(Batch ... batches) {
        if (this.batches == null) {
            this.setBatches(new ArrayList<Batch>(batches.length));
        }
        for (Batch ele : batches) {
            this.batches.add(ele);
        }
        return this;
    }

    public AppflowIntegration withBatches(Collection<Batch> batches) {
        this.setBatches(batches);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFlowDefinition() != null) {
            sb.append("FlowDefinition: ").append(this.getFlowDefinition()).append(",");
        }
        if (this.getBatches() != null) {
            sb.append("Batches: ").append(this.getBatches());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppflowIntegration)) {
            return false;
        }
        AppflowIntegration other = (AppflowIntegration)obj;
        if (other.getFlowDefinition() == null ^ this.getFlowDefinition() == null) {
            return false;
        }
        if (other.getFlowDefinition() != null && !other.getFlowDefinition().equals(this.getFlowDefinition())) {
            return false;
        }
        if (other.getBatches() == null ^ this.getBatches() == null) {
            return false;
        }
        return other.getBatches() == null || other.getBatches().equals(this.getBatches());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFlowDefinition() == null ? 0 : this.getFlowDefinition().hashCode());
        hashCode = 31 * hashCode + (this.getBatches() == null ? 0 : this.getBatches().hashCode());
        return hashCode;
    }

    public AppflowIntegration clone() {
        try {
            return (AppflowIntegration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AppflowIntegrationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

