/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.costexplorer.model.CurrentInstance;
import com.amazonaws.services.costexplorer.model.FindingReasonCode;
import com.amazonaws.services.costexplorer.model.ModifyRecommendationDetail;
import com.amazonaws.services.costexplorer.model.RightsizingType;
import com.amazonaws.services.costexplorer.model.TerminateRecommendationDetail;
import com.amazonaws.services.costexplorer.model.transform.RightsizingRecommendationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RightsizingRecommendation
implements Serializable,
Cloneable,
StructuredPojo {
    private String accountId;
    private CurrentInstance currentInstance;
    private String rightsizingType;
    private ModifyRecommendationDetail modifyRecommendationDetail;
    private TerminateRecommendationDetail terminateRecommendationDetail;
    private List<String> findingReasonCodes;

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public RightsizingRecommendation withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setCurrentInstance(CurrentInstance currentInstance) {
        this.currentInstance = currentInstance;
    }

    public CurrentInstance getCurrentInstance() {
        return this.currentInstance;
    }

    public RightsizingRecommendation withCurrentInstance(CurrentInstance currentInstance) {
        this.setCurrentInstance(currentInstance);
        return this;
    }

    public void setRightsizingType(String rightsizingType) {
        this.rightsizingType = rightsizingType;
    }

    public String getRightsizingType() {
        return this.rightsizingType;
    }

    public RightsizingRecommendation withRightsizingType(String rightsizingType) {
        this.setRightsizingType(rightsizingType);
        return this;
    }

    public RightsizingRecommendation withRightsizingType(RightsizingType rightsizingType) {
        this.rightsizingType = rightsizingType.toString();
        return this;
    }

    public void setModifyRecommendationDetail(ModifyRecommendationDetail modifyRecommendationDetail) {
        this.modifyRecommendationDetail = modifyRecommendationDetail;
    }

    public ModifyRecommendationDetail getModifyRecommendationDetail() {
        return this.modifyRecommendationDetail;
    }

    public RightsizingRecommendation withModifyRecommendationDetail(ModifyRecommendationDetail modifyRecommendationDetail) {
        this.setModifyRecommendationDetail(modifyRecommendationDetail);
        return this;
    }

    public void setTerminateRecommendationDetail(TerminateRecommendationDetail terminateRecommendationDetail) {
        this.terminateRecommendationDetail = terminateRecommendationDetail;
    }

    public TerminateRecommendationDetail getTerminateRecommendationDetail() {
        return this.terminateRecommendationDetail;
    }

    public RightsizingRecommendation withTerminateRecommendationDetail(TerminateRecommendationDetail terminateRecommendationDetail) {
        this.setTerminateRecommendationDetail(terminateRecommendationDetail);
        return this;
    }

    public List<String> getFindingReasonCodes() {
        return this.findingReasonCodes;
    }

    public void setFindingReasonCodes(Collection<String> findingReasonCodes) {
        if (findingReasonCodes == null) {
            this.findingReasonCodes = null;
            return;
        }
        this.findingReasonCodes = new ArrayList<String>(findingReasonCodes);
    }

    public RightsizingRecommendation withFindingReasonCodes(String ... findingReasonCodes) {
        if (this.findingReasonCodes == null) {
            this.setFindingReasonCodes(new ArrayList<String>(findingReasonCodes.length));
        }
        for (String ele : findingReasonCodes) {
            this.findingReasonCodes.add(ele);
        }
        return this;
    }

    public RightsizingRecommendation withFindingReasonCodes(Collection<String> findingReasonCodes) {
        this.setFindingReasonCodes(findingReasonCodes);
        return this;
    }

    public RightsizingRecommendation withFindingReasonCodes(FindingReasonCode ... findingReasonCodes) {
        ArrayList<String> findingReasonCodesCopy = new ArrayList<String>(findingReasonCodes.length);
        for (FindingReasonCode value : findingReasonCodes) {
            findingReasonCodesCopy.add(value.toString());
        }
        if (this.getFindingReasonCodes() == null) {
            this.setFindingReasonCodes(findingReasonCodesCopy);
        } else {
            this.getFindingReasonCodes().addAll(findingReasonCodesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getCurrentInstance() != null) {
            sb.append("CurrentInstance: ").append(this.getCurrentInstance()).append(",");
        }
        if (this.getRightsizingType() != null) {
            sb.append("RightsizingType: ").append(this.getRightsizingType()).append(",");
        }
        if (this.getModifyRecommendationDetail() != null) {
            sb.append("ModifyRecommendationDetail: ").append(this.getModifyRecommendationDetail()).append(",");
        }
        if (this.getTerminateRecommendationDetail() != null) {
            sb.append("TerminateRecommendationDetail: ").append(this.getTerminateRecommendationDetail()).append(",");
        }
        if (this.getFindingReasonCodes() != null) {
            sb.append("FindingReasonCodes: ").append(this.getFindingReasonCodes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RightsizingRecommendation)) {
            return false;
        }
        RightsizingRecommendation other = (RightsizingRecommendation)obj;
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getCurrentInstance() == null ^ this.getCurrentInstance() == null) {
            return false;
        }
        if (other.getCurrentInstance() != null && !other.getCurrentInstance().equals(this.getCurrentInstance())) {
            return false;
        }
        if (other.getRightsizingType() == null ^ this.getRightsizingType() == null) {
            return false;
        }
        if (other.getRightsizingType() != null && !other.getRightsizingType().equals(this.getRightsizingType())) {
            return false;
        }
        if (other.getModifyRecommendationDetail() == null ^ this.getModifyRecommendationDetail() == null) {
            return false;
        }
        if (other.getModifyRecommendationDetail() != null && !other.getModifyRecommendationDetail().equals(this.getModifyRecommendationDetail())) {
            return false;
        }
        if (other.getTerminateRecommendationDetail() == null ^ this.getTerminateRecommendationDetail() == null) {
            return false;
        }
        if (other.getTerminateRecommendationDetail() != null && !other.getTerminateRecommendationDetail().equals(this.getTerminateRecommendationDetail())) {
            return false;
        }
        if (other.getFindingReasonCodes() == null ^ this.getFindingReasonCodes() == null) {
            return false;
        }
        return other.getFindingReasonCodes() == null || other.getFindingReasonCodes().equals(this.getFindingReasonCodes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentInstance() == null ? 0 : this.getCurrentInstance().hashCode());
        hashCode = 31 * hashCode + (this.getRightsizingType() == null ? 0 : this.getRightsizingType().hashCode());
        hashCode = 31 * hashCode + (this.getModifyRecommendationDetail() == null ? 0 : this.getModifyRecommendationDetail().hashCode());
        hashCode = 31 * hashCode + (this.getTerminateRecommendationDetail() == null ? 0 : this.getTerminateRecommendationDetail().hashCode());
        hashCode = 31 * hashCode + (this.getFindingReasonCodes() == null ? 0 : this.getFindingReasonCodes().hashCode());
        return hashCode;
    }

    public RightsizingRecommendation clone() {
        try {
            return (RightsizingRecommendation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RightsizingRecommendationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

