/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costexplorer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.costexplorer.model.Expression;
import java.util.List;

@SdkInternalApi
public class ExpressionMarshaller {
    private static final MarshallingInfo<List> OR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Or").build();
    private static final MarshallingInfo<List> AND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("And").build();
    private static final MarshallingInfo<StructuredPojo> NOT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Not").build();
    private static final MarshallingInfo<StructuredPojo> DIMENSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Dimensions").build();
    private static final MarshallingInfo<StructuredPojo> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final ExpressionMarshaller instance = new ExpressionMarshaller();

    public static ExpressionMarshaller getInstance() {
        return instance;
    }

    public void marshall(Expression expression, ProtocolMarshaller protocolMarshaller) {
        if (expression == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(expression.getOr(), OR_BINDING);
            protocolMarshaller.marshall(expression.getAnd(), AND_BINDING);
            protocolMarshaller.marshall((Object)expression.getNot(), NOT_BINDING);
            protocolMarshaller.marshall((Object)expression.getDimensions(), DIMENSIONS_BINDING);
            protocolMarshaller.marshall((Object)expression.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

