/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connect.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A structure that defines search criteria for contacts using analysis outputs from Amazon Connect Contact Lens.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ContactAnalysis" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ContactAnalysis implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Search criteria based on transcript analyzed by Amazon Connect Contact Lens.
     * </p>
     */
    private Transcript transcript;

    /**
     * <p>
     * Search criteria based on transcript analyzed by Amazon Connect Contact Lens.
     * </p>
     * 
     * @param transcript
     *        Search criteria based on transcript analyzed by Amazon Connect Contact Lens.
     */

    public void setTranscript(Transcript transcript) {
        this.transcript = transcript;
    }

    /**
     * <p>
     * Search criteria based on transcript analyzed by Amazon Connect Contact Lens.
     * </p>
     * 
     * @return Search criteria based on transcript analyzed by Amazon Connect Contact Lens.
     */

    public Transcript getTranscript() {
        return this.transcript;
    }

    /**
     * <p>
     * Search criteria based on transcript analyzed by Amazon Connect Contact Lens.
     * </p>
     * 
     * @param transcript
     *        Search criteria based on transcript analyzed by Amazon Connect Contact Lens.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ContactAnalysis withTranscript(Transcript transcript) {
        setTranscript(transcript);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTranscript() != null)
            sb.append("Transcript: ").append(getTranscript());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ContactAnalysis == false)
            return false;
        ContactAnalysis other = (ContactAnalysis) obj;
        if (other.getTranscript() == null ^ this.getTranscript() == null)
            return false;
        if (other.getTranscript() != null && other.getTranscript().equals(this.getTranscript()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getTranscript() == null) ? 0 : getTranscript().hashCode());
        return hashCode;
    }

    @Override
    public ContactAnalysis clone() {
        try {
            return (ContactAnalysis) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.connect.model.transform.ContactAnalysisMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
