/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.connect.model.MetricDataV2;
import com.amazonaws.services.connect.model.MetricInterval;
import com.amazonaws.services.connect.model.transform.MetricResultV2Marshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetricResultV2
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, String> dimensions;
    private MetricInterval metricInterval;
    private List<MetricDataV2> collections;

    public Map<String, String> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Map<String, String> dimensions) {
        this.dimensions = dimensions;
    }

    public MetricResultV2 withDimensions(Map<String, String> dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public MetricResultV2 addDimensionsEntry(String key, String value) {
        if (null == this.dimensions) {
            this.dimensions = new HashMap<String, String>();
        }
        if (this.dimensions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.dimensions.put(key, value);
        return this;
    }

    public MetricResultV2 clearDimensionsEntries() {
        this.dimensions = null;
        return this;
    }

    public void setMetricInterval(MetricInterval metricInterval) {
        this.metricInterval = metricInterval;
    }

    public MetricInterval getMetricInterval() {
        return this.metricInterval;
    }

    public MetricResultV2 withMetricInterval(MetricInterval metricInterval) {
        this.setMetricInterval(metricInterval);
        return this;
    }

    public List<MetricDataV2> getCollections() {
        return this.collections;
    }

    public void setCollections(Collection<MetricDataV2> collections) {
        if (collections == null) {
            this.collections = null;
            return;
        }
        this.collections = new ArrayList<MetricDataV2>(collections);
    }

    public MetricResultV2 withCollections(MetricDataV2 ... collections) {
        if (this.collections == null) {
            this.setCollections(new ArrayList<MetricDataV2>(collections.length));
        }
        for (MetricDataV2 ele : collections) {
            this.collections.add(ele);
        }
        return this;
    }

    public MetricResultV2 withCollections(Collection<MetricDataV2> collections) {
        this.setCollections(collections);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDimensions() != null) {
            sb.append("Dimensions: ").append(this.getDimensions()).append(",");
        }
        if (this.getMetricInterval() != null) {
            sb.append("MetricInterval: ").append(this.getMetricInterval()).append(",");
        }
        if (this.getCollections() != null) {
            sb.append("Collections: ").append(this.getCollections());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricResultV2)) {
            return false;
        }
        MetricResultV2 other = (MetricResultV2)obj;
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        if (other.getDimensions() != null && !other.getDimensions().equals(this.getDimensions())) {
            return false;
        }
        if (other.getMetricInterval() == null ^ this.getMetricInterval() == null) {
            return false;
        }
        if (other.getMetricInterval() != null && !other.getMetricInterval().equals(this.getMetricInterval())) {
            return false;
        }
        if (other.getCollections() == null ^ this.getCollections() == null) {
            return false;
        }
        return other.getCollections() == null || other.getCollections().equals(this.getCollections());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getMetricInterval() == null ? 0 : this.getMetricInterval().hashCode());
        hashCode = 31 * hashCode + (this.getCollections() == null ? 0 : this.getCollections().hashCode());
        return hashCode;
    }

    public MetricResultV2 clone() {
        try {
            return (MetricResultV2)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MetricResultV2Marshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

