/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.connect.model.ReferenceType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListContactReferencesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String instanceId;
    private String contactId;
    private List<String> referenceTypes;
    private String nextToken;

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public ListContactReferencesRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public void setContactId(String contactId) {
        this.contactId = contactId;
    }

    public String getContactId() {
        return this.contactId;
    }

    public ListContactReferencesRequest withContactId(String contactId) {
        this.setContactId(contactId);
        return this;
    }

    public List<String> getReferenceTypes() {
        return this.referenceTypes;
    }

    public void setReferenceTypes(Collection<String> referenceTypes) {
        if (referenceTypes == null) {
            this.referenceTypes = null;
            return;
        }
        this.referenceTypes = new ArrayList<String>(referenceTypes);
    }

    public ListContactReferencesRequest withReferenceTypes(String ... referenceTypes) {
        if (this.referenceTypes == null) {
            this.setReferenceTypes(new ArrayList<String>(referenceTypes.length));
        }
        for (String ele : referenceTypes) {
            this.referenceTypes.add(ele);
        }
        return this;
    }

    public ListContactReferencesRequest withReferenceTypes(Collection<String> referenceTypes) {
        this.setReferenceTypes(referenceTypes);
        return this;
    }

    public ListContactReferencesRequest withReferenceTypes(ReferenceType ... referenceTypes) {
        ArrayList<String> referenceTypesCopy = new ArrayList<String>(referenceTypes.length);
        for (ReferenceType value : referenceTypes) {
            referenceTypesCopy.add(value.toString());
        }
        if (this.getReferenceTypes() == null) {
            this.setReferenceTypes(referenceTypesCopy);
        } else {
            this.getReferenceTypes().addAll(referenceTypesCopy);
        }
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListContactReferencesRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getContactId() != null) {
            sb.append("ContactId: ").append(this.getContactId()).append(",");
        }
        if (this.getReferenceTypes() != null) {
            sb.append("ReferenceTypes: ").append(this.getReferenceTypes()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListContactReferencesRequest)) {
            return false;
        }
        ListContactReferencesRequest other = (ListContactReferencesRequest)obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getContactId() == null ^ this.getContactId() == null) {
            return false;
        }
        if (other.getContactId() != null && !other.getContactId().equals(this.getContactId())) {
            return false;
        }
        if (other.getReferenceTypes() == null ^ this.getReferenceTypes() == null) {
            return false;
        }
        if (other.getReferenceTypes() != null && !other.getReferenceTypes().equals(this.getReferenceTypes())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getContactId() == null ? 0 : this.getContactId().hashCode());
        hashCode = 31 * hashCode + (this.getReferenceTypes() == null ? 0 : this.getReferenceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListContactReferencesRequest clone() {
        return (ListContactReferencesRequest)super.clone();
    }
}

