/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.config.model.ResourceType;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListDiscoveredResourcesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String resourceType;
    private SdkInternalList<String> resourceIds;
    private String resourceName;
    private Integer limit;
    private Boolean includeDeletedResources;
    private String nextToken;

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public ListDiscoveredResourcesRequest withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public void setResourceType(ResourceType resourceType) {
        this.resourceType = resourceType.toString();
    }

    public ListDiscoveredResourcesRequest withResourceType(ResourceType resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public List<String> getResourceIds() {
        if (this.resourceIds == null) {
            this.resourceIds = new SdkInternalList();
        }
        return this.resourceIds;
    }

    public void setResourceIds(Collection<String> resourceIds) {
        if (resourceIds == null) {
            this.resourceIds = null;
            return;
        }
        this.resourceIds = new SdkInternalList(resourceIds);
    }

    public ListDiscoveredResourcesRequest withResourceIds(String ... resourceIds) {
        if (this.resourceIds == null) {
            this.setResourceIds((Collection<String>)new SdkInternalList(resourceIds.length));
        }
        for (String ele : resourceIds) {
            this.resourceIds.add((Object)ele);
        }
        return this;
    }

    public ListDiscoveredResourcesRequest withResourceIds(Collection<String> resourceIds) {
        this.setResourceIds(resourceIds);
        return this;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public ListDiscoveredResourcesRequest withResourceName(String resourceName) {
        this.setResourceName(resourceName);
        return this;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public ListDiscoveredResourcesRequest withLimit(Integer limit) {
        this.setLimit(limit);
        return this;
    }

    public void setIncludeDeletedResources(Boolean includeDeletedResources) {
        this.includeDeletedResources = includeDeletedResources;
    }

    public Boolean getIncludeDeletedResources() {
        return this.includeDeletedResources;
    }

    public ListDiscoveredResourcesRequest withIncludeDeletedResources(Boolean includeDeletedResources) {
        this.setIncludeDeletedResources(includeDeletedResources);
        return this;
    }

    public Boolean isIncludeDeletedResources() {
        return this.includeDeletedResources;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListDiscoveredResourcesRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceType() != null) {
            sb.append("ResourceType: ").append(this.getResourceType()).append(",");
        }
        if (this.getResourceIds() != null) {
            sb.append("ResourceIds: ").append(this.getResourceIds()).append(",");
        }
        if (this.getResourceName() != null) {
            sb.append("ResourceName: ").append(this.getResourceName()).append(",");
        }
        if (this.getLimit() != null) {
            sb.append("Limit: ").append(this.getLimit()).append(",");
        }
        if (this.getIncludeDeletedResources() != null) {
            sb.append("IncludeDeletedResources: ").append(this.getIncludeDeletedResources()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDiscoveredResourcesRequest)) {
            return false;
        }
        ListDiscoveredResourcesRequest other = (ListDiscoveredResourcesRequest)obj;
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        if (other.getResourceType() != null && !other.getResourceType().equals(this.getResourceType())) {
            return false;
        }
        if (other.getResourceIds() == null ^ this.getResourceIds() == null) {
            return false;
        }
        if (other.getResourceIds() != null && !other.getResourceIds().equals(this.getResourceIds())) {
            return false;
        }
        if (other.getResourceName() == null ^ this.getResourceName() == null) {
            return false;
        }
        if (other.getResourceName() != null && !other.getResourceName().equals(this.getResourceName())) {
            return false;
        }
        if (other.getLimit() == null ^ this.getLimit() == null) {
            return false;
        }
        if (other.getLimit() != null && !other.getLimit().equals(this.getLimit())) {
            return false;
        }
        if (other.getIncludeDeletedResources() == null ^ this.getIncludeDeletedResources() == null) {
            return false;
        }
        if (other.getIncludeDeletedResources() != null && !other.getIncludeDeletedResources().equals(this.getIncludeDeletedResources())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        hashCode = 31 * hashCode + (this.getResourceIds() == null ? 0 : this.getResourceIds().hashCode());
        hashCode = 31 * hashCode + (this.getResourceName() == null ? 0 : this.getResourceName().hashCode());
        hashCode = 31 * hashCode + (this.getLimit() == null ? 0 : this.getLimit().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeDeletedResources() == null ? 0 : this.getIncludeDeletedResources().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListDiscoveredResourcesRequest clone() {
        return (ListDiscoveredResourcesRequest)super.clone();
    }
}

