/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.config.model.ResourceIdentifier;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListDiscoveredResourcesResult
implements Serializable,
Cloneable {
    private SdkInternalList<ResourceIdentifier> resourceIdentifiers;
    private String nextToken;

    public List<ResourceIdentifier> getResourceIdentifiers() {
        if (this.resourceIdentifiers == null) {
            this.resourceIdentifiers = new SdkInternalList();
        }
        return this.resourceIdentifiers;
    }

    public void setResourceIdentifiers(Collection<ResourceIdentifier> resourceIdentifiers) {
        if (resourceIdentifiers == null) {
            this.resourceIdentifiers = null;
            return;
        }
        this.resourceIdentifiers = new SdkInternalList(resourceIdentifiers);
    }

    public ListDiscoveredResourcesResult withResourceIdentifiers(ResourceIdentifier ... resourceIdentifiers) {
        if (this.resourceIdentifiers == null) {
            this.setResourceIdentifiers((Collection<ResourceIdentifier>)new SdkInternalList(resourceIdentifiers.length));
        }
        for (ResourceIdentifier ele : resourceIdentifiers) {
            this.resourceIdentifiers.add((Object)ele);
        }
        return this;
    }

    public ListDiscoveredResourcesResult withResourceIdentifiers(Collection<ResourceIdentifier> resourceIdentifiers) {
        this.setResourceIdentifiers(resourceIdentifiers);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListDiscoveredResourcesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceIdentifiers() != null) {
            sb.append("ResourceIdentifiers: " + this.getResourceIdentifiers() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDiscoveredResourcesResult)) {
            return false;
        }
        ListDiscoveredResourcesResult other = (ListDiscoveredResourcesResult)obj;
        if (other.getResourceIdentifiers() == null ^ this.getResourceIdentifiers() == null) {
            return false;
        }
        if (other.getResourceIdentifiers() != null && !other.getResourceIdentifiers().equals(this.getResourceIdentifiers())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceIdentifiers() == null ? 0 : this.getResourceIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListDiscoveredResourcesResult clone() {
        try {
            return (ListDiscoveredResourcesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

