/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandlerV2;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.config.AmazonConfig;
import com.amazonaws.services.config.model.DeleteConfigRuleRequest;
import com.amazonaws.services.config.model.DeleteDeliveryChannelRequest;
import com.amazonaws.services.config.model.DeliverConfigSnapshotRequest;
import com.amazonaws.services.config.model.DeliverConfigSnapshotResult;
import com.amazonaws.services.config.model.DescribeComplianceByConfigRuleRequest;
import com.amazonaws.services.config.model.DescribeComplianceByConfigRuleResult;
import com.amazonaws.services.config.model.DescribeComplianceByResourceRequest;
import com.amazonaws.services.config.model.DescribeComplianceByResourceResult;
import com.amazonaws.services.config.model.DescribeConfigRuleEvaluationStatusRequest;
import com.amazonaws.services.config.model.DescribeConfigRuleEvaluationStatusResult;
import com.amazonaws.services.config.model.DescribeConfigRulesRequest;
import com.amazonaws.services.config.model.DescribeConfigRulesResult;
import com.amazonaws.services.config.model.DescribeConfigurationRecorderStatusRequest;
import com.amazonaws.services.config.model.DescribeConfigurationRecorderStatusResult;
import com.amazonaws.services.config.model.DescribeConfigurationRecordersRequest;
import com.amazonaws.services.config.model.DescribeConfigurationRecordersResult;
import com.amazonaws.services.config.model.DescribeDeliveryChannelStatusRequest;
import com.amazonaws.services.config.model.DescribeDeliveryChannelStatusResult;
import com.amazonaws.services.config.model.DescribeDeliveryChannelsRequest;
import com.amazonaws.services.config.model.DescribeDeliveryChannelsResult;
import com.amazonaws.services.config.model.GetComplianceDetailsByConfigRuleRequest;
import com.amazonaws.services.config.model.GetComplianceDetailsByConfigRuleResult;
import com.amazonaws.services.config.model.GetComplianceDetailsByResourceRequest;
import com.amazonaws.services.config.model.GetComplianceDetailsByResourceResult;
import com.amazonaws.services.config.model.GetComplianceSummaryByConfigRuleRequest;
import com.amazonaws.services.config.model.GetComplianceSummaryByConfigRuleResult;
import com.amazonaws.services.config.model.GetComplianceSummaryByResourceTypeRequest;
import com.amazonaws.services.config.model.GetComplianceSummaryByResourceTypeResult;
import com.amazonaws.services.config.model.GetResourceConfigHistoryRequest;
import com.amazonaws.services.config.model.GetResourceConfigHistoryResult;
import com.amazonaws.services.config.model.InsufficientDeliveryPolicyException;
import com.amazonaws.services.config.model.InsufficientPermissionsException;
import com.amazonaws.services.config.model.InvalidConfigurationRecorderNameException;
import com.amazonaws.services.config.model.InvalidDeliveryChannelNameException;
import com.amazonaws.services.config.model.InvalidLimitException;
import com.amazonaws.services.config.model.InvalidNextTokenException;
import com.amazonaws.services.config.model.InvalidParameterValueException;
import com.amazonaws.services.config.model.InvalidRecordingGroupException;
import com.amazonaws.services.config.model.InvalidResultTokenException;
import com.amazonaws.services.config.model.InvalidRoleException;
import com.amazonaws.services.config.model.InvalidS3KeyPrefixException;
import com.amazonaws.services.config.model.InvalidSNSTopicARNException;
import com.amazonaws.services.config.model.InvalidTimeRangeException;
import com.amazonaws.services.config.model.LastDeliveryChannelDeleteFailedException;
import com.amazonaws.services.config.model.ListDiscoveredResourcesRequest;
import com.amazonaws.services.config.model.ListDiscoveredResourcesResult;
import com.amazonaws.services.config.model.MaxNumberOfConfigRulesExceededException;
import com.amazonaws.services.config.model.MaxNumberOfConfigurationRecordersExceededException;
import com.amazonaws.services.config.model.MaxNumberOfDeliveryChannelsExceededException;
import com.amazonaws.services.config.model.NoAvailableConfigurationRecorderException;
import com.amazonaws.services.config.model.NoAvailableDeliveryChannelException;
import com.amazonaws.services.config.model.NoRunningConfigurationRecorderException;
import com.amazonaws.services.config.model.NoSuchBucketException;
import com.amazonaws.services.config.model.NoSuchConfigRuleException;
import com.amazonaws.services.config.model.NoSuchConfigurationRecorderException;
import com.amazonaws.services.config.model.NoSuchDeliveryChannelException;
import com.amazonaws.services.config.model.PutConfigRuleRequest;
import com.amazonaws.services.config.model.PutConfigurationRecorderRequest;
import com.amazonaws.services.config.model.PutDeliveryChannelRequest;
import com.amazonaws.services.config.model.PutEvaluationsRequest;
import com.amazonaws.services.config.model.PutEvaluationsResult;
import com.amazonaws.services.config.model.ResourceInUseException;
import com.amazonaws.services.config.model.ResourceNotDiscoveredException;
import com.amazonaws.services.config.model.StartConfigurationRecorderRequest;
import com.amazonaws.services.config.model.StopConfigurationRecorderRequest;
import com.amazonaws.services.config.model.ValidationException;
import com.amazonaws.services.config.model.transform.DeleteConfigRuleRequestMarshaller;
import com.amazonaws.services.config.model.transform.DeleteDeliveryChannelRequestMarshaller;
import com.amazonaws.services.config.model.transform.DeliverConfigSnapshotRequestMarshaller;
import com.amazonaws.services.config.model.transform.DeliverConfigSnapshotResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.DescribeComplianceByConfigRuleRequestMarshaller;
import com.amazonaws.services.config.model.transform.DescribeComplianceByConfigRuleResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.DescribeComplianceByResourceRequestMarshaller;
import com.amazonaws.services.config.model.transform.DescribeComplianceByResourceResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.DescribeConfigRuleEvaluationStatusRequestMarshaller;
import com.amazonaws.services.config.model.transform.DescribeConfigRuleEvaluationStatusResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.DescribeConfigRulesRequestMarshaller;
import com.amazonaws.services.config.model.transform.DescribeConfigRulesResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.DescribeConfigurationRecorderStatusRequestMarshaller;
import com.amazonaws.services.config.model.transform.DescribeConfigurationRecorderStatusResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.DescribeConfigurationRecordersRequestMarshaller;
import com.amazonaws.services.config.model.transform.DescribeConfigurationRecordersResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.DescribeDeliveryChannelStatusRequestMarshaller;
import com.amazonaws.services.config.model.transform.DescribeDeliveryChannelStatusResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.DescribeDeliveryChannelsRequestMarshaller;
import com.amazonaws.services.config.model.transform.DescribeDeliveryChannelsResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.GetComplianceDetailsByConfigRuleRequestMarshaller;
import com.amazonaws.services.config.model.transform.GetComplianceDetailsByConfigRuleResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.GetComplianceDetailsByResourceRequestMarshaller;
import com.amazonaws.services.config.model.transform.GetComplianceDetailsByResourceResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.GetComplianceSummaryByConfigRuleRequestMarshaller;
import com.amazonaws.services.config.model.transform.GetComplianceSummaryByConfigRuleResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.GetComplianceSummaryByResourceTypeRequestMarshaller;
import com.amazonaws.services.config.model.transform.GetComplianceSummaryByResourceTypeResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.GetResourceConfigHistoryRequestMarshaller;
import com.amazonaws.services.config.model.transform.GetResourceConfigHistoryResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.ListDiscoveredResourcesRequestMarshaller;
import com.amazonaws.services.config.model.transform.ListDiscoveredResourcesResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.PutConfigRuleRequestMarshaller;
import com.amazonaws.services.config.model.transform.PutConfigurationRecorderRequestMarshaller;
import com.amazonaws.services.config.model.transform.PutDeliveryChannelRequestMarshaller;
import com.amazonaws.services.config.model.transform.PutEvaluationsRequestMarshaller;
import com.amazonaws.services.config.model.transform.PutEvaluationsResultJsonUnmarshaller;
import com.amazonaws.services.config.model.transform.StartConfigurationRecorderRequestMarshaller;
import com.amazonaws.services.config.model.transform.StopConfigurationRecorderRequestMarshaller;
import com.amazonaws.transform.JsonErrorUnmarshallerV2;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonConfigClient
extends AmazonWebServiceClient
implements AmazonConfig {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonConfig.class);
    private static final String DEFAULT_SIGNING_NAME = "config";
    private static final String DEFAULT_ENDPOINT_PREFIX = "config";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    protected List<JsonErrorUnmarshallerV2> jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshallerV2>();

    public AmazonConfigClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), configFactory.getConfig());
    }

    public AmazonConfigClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonConfigClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AmazonConfigClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonConfigClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AmazonConfigClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonConfigClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ResourceInUseException.class, "ResourceInUseException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(NoAvailableDeliveryChannelException.class, "NoAvailableDeliveryChannelException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidResultTokenException.class, "InvalidResultTokenException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidParameterValueException.class, "InvalidParameterValueException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidLimitException.class, "InvalidLimitException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidConfigurationRecorderNameException.class, "InvalidConfigurationRecorderNameException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(MaxNumberOfConfigurationRecordersExceededException.class, "MaxNumberOfConfigurationRecordersExceededException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(LastDeliveryChannelDeleteFailedException.class, "LastDeliveryChannelDeleteFailedException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ValidationException.class, "ValidationException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidNextTokenException.class, "InvalidNextTokenException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidS3KeyPrefixException.class, "InvalidS3KeyPrefixException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(NoSuchConfigurationRecorderException.class, "NoSuchConfigurationRecorderException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidTimeRangeException.class, "InvalidTimeRangeException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidSNSTopicARNException.class, "InvalidSNSTopicARNException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(NoAvailableConfigurationRecorderException.class, "NoAvailableConfigurationRecorderException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidRecordingGroupException.class, "InvalidRecordingGroupException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(NoSuchDeliveryChannelException.class, "NoSuchDeliveryChannelException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(MaxNumberOfConfigRulesExceededException.class, "MaxNumberOfConfigRulesExceededException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(NoSuchConfigRuleException.class, "NoSuchConfigRuleException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(MaxNumberOfDeliveryChannelsExceededException.class, "MaxNumberOfDeliveryChannelsExceededException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidRoleException.class, "InvalidRoleException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InsufficientPermissionsException.class, "InsufficientPermissionsException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(ResourceNotDiscoveredException.class, "ResourceNotDiscoveredException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidDeliveryChannelNameException.class, "InvalidDeliveryChannelNameException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InsufficientDeliveryPolicyException.class, "InsufficientDeliveryPolicyException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(NoRunningConfigurationRecorderException.class, "NoRunningConfigurationRecorderException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(NoSuchBucketException.class, "NoSuchBucketException"));
        this.jsonErrorUnmarshallers.add(JsonErrorUnmarshallerV2.DEFAULT_UNMARSHALLER);
        this.setServiceNameIntern("config");
        this.setEndpointPrefix("config");
        this.setEndpoint("config.us-east-1.amazonaws.com/");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/config/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/config/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteConfigRule(DeleteConfigRuleRequest deleteConfigRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteConfigRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteConfigRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteConfigRuleRequestMarshaller().marshall((DeleteConfigRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteConfigRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler(null, (boolean)false);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteDeliveryChannel(DeleteDeliveryChannelRequest deleteDeliveryChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDeliveryChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteDeliveryChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteDeliveryChannelRequestMarshaller().marshall((DeleteDeliveryChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteDeliveryChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler(null, (boolean)false);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeliverConfigSnapshotResult deliverConfigSnapshot(DeliverConfigSnapshotRequest deliverConfigSnapshotRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deliverConfigSnapshotRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeliverConfigSnapshotRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeliverConfigSnapshotRequestMarshaller().marshall((DeliverConfigSnapshotRequest)super.beforeMarshalling((AmazonWebServiceRequest)deliverConfigSnapshotRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new DeliverConfigSnapshotResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeliverConfigSnapshotResult deliverConfigSnapshotResult = (DeliverConfigSnapshotResult)response.getAwsResponse();
            return deliverConfigSnapshotResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeComplianceByConfigRuleResult describeComplianceByConfigRule(DescribeComplianceByConfigRuleRequest describeComplianceByConfigRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeComplianceByConfigRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeComplianceByConfigRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeComplianceByConfigRuleRequestMarshaller().marshall((DescribeComplianceByConfigRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeComplianceByConfigRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new DescribeComplianceByConfigRuleResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeComplianceByConfigRuleResult describeComplianceByConfigRuleResult = (DescribeComplianceByConfigRuleResult)response.getAwsResponse();
            return describeComplianceByConfigRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeComplianceByConfigRuleResult describeComplianceByConfigRule() {
        return this.describeComplianceByConfigRule(new DescribeComplianceByConfigRuleRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeComplianceByResourceResult describeComplianceByResource(DescribeComplianceByResourceRequest describeComplianceByResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeComplianceByResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeComplianceByResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeComplianceByResourceRequestMarshaller().marshall((DescribeComplianceByResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeComplianceByResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new DescribeComplianceByResourceResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeComplianceByResourceResult describeComplianceByResourceResult = (DescribeComplianceByResourceResult)response.getAwsResponse();
            return describeComplianceByResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeComplianceByResourceResult describeComplianceByResource() {
        return this.describeComplianceByResource(new DescribeComplianceByResourceRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConfigRuleEvaluationStatusResult describeConfigRuleEvaluationStatus(DescribeConfigRuleEvaluationStatusRequest describeConfigRuleEvaluationStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeConfigRuleEvaluationStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeConfigRuleEvaluationStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeConfigRuleEvaluationStatusRequestMarshaller().marshall((DescribeConfigRuleEvaluationStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeConfigRuleEvaluationStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new DescribeConfigRuleEvaluationStatusResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeConfigRuleEvaluationStatusResult describeConfigRuleEvaluationStatusResult = (DescribeConfigRuleEvaluationStatusResult)response.getAwsResponse();
            return describeConfigRuleEvaluationStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeConfigRuleEvaluationStatusResult describeConfigRuleEvaluationStatus() {
        return this.describeConfigRuleEvaluationStatus(new DescribeConfigRuleEvaluationStatusRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConfigRulesResult describeConfigRules(DescribeConfigRulesRequest describeConfigRulesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeConfigRulesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeConfigRulesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeConfigRulesRequestMarshaller().marshall((DescribeConfigRulesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeConfigRulesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new DescribeConfigRulesResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeConfigRulesResult describeConfigRulesResult = (DescribeConfigRulesResult)response.getAwsResponse();
            return describeConfigRulesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeConfigRulesResult describeConfigRules() {
        return this.describeConfigRules(new DescribeConfigRulesRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConfigurationRecorderStatusResult describeConfigurationRecorderStatus(DescribeConfigurationRecorderStatusRequest describeConfigurationRecorderStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeConfigurationRecorderStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeConfigurationRecorderStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeConfigurationRecorderStatusRequestMarshaller().marshall((DescribeConfigurationRecorderStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeConfigurationRecorderStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new DescribeConfigurationRecorderStatusResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeConfigurationRecorderStatusResult describeConfigurationRecorderStatusResult = (DescribeConfigurationRecorderStatusResult)response.getAwsResponse();
            return describeConfigurationRecorderStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeConfigurationRecorderStatusResult describeConfigurationRecorderStatus() {
        return this.describeConfigurationRecorderStatus(new DescribeConfigurationRecorderStatusRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConfigurationRecordersResult describeConfigurationRecorders(DescribeConfigurationRecordersRequest describeConfigurationRecordersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeConfigurationRecordersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeConfigurationRecordersRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeConfigurationRecordersRequestMarshaller().marshall((DescribeConfigurationRecordersRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeConfigurationRecordersRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new DescribeConfigurationRecordersResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeConfigurationRecordersResult describeConfigurationRecordersResult = (DescribeConfigurationRecordersResult)response.getAwsResponse();
            return describeConfigurationRecordersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeConfigurationRecordersResult describeConfigurationRecorders() {
        return this.describeConfigurationRecorders(new DescribeConfigurationRecordersRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDeliveryChannelStatusResult describeDeliveryChannelStatus(DescribeDeliveryChannelStatusRequest describeDeliveryChannelStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDeliveryChannelStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDeliveryChannelStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDeliveryChannelStatusRequestMarshaller().marshall((DescribeDeliveryChannelStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeDeliveryChannelStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new DescribeDeliveryChannelStatusResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeDeliveryChannelStatusResult describeDeliveryChannelStatusResult = (DescribeDeliveryChannelStatusResult)response.getAwsResponse();
            return describeDeliveryChannelStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDeliveryChannelStatusResult describeDeliveryChannelStatus() {
        return this.describeDeliveryChannelStatus(new DescribeDeliveryChannelStatusRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDeliveryChannelsResult describeDeliveryChannels(DescribeDeliveryChannelsRequest describeDeliveryChannelsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDeliveryChannelsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeDeliveryChannelsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeDeliveryChannelsRequestMarshaller().marshall((DescribeDeliveryChannelsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeDeliveryChannelsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new DescribeDeliveryChannelsResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeDeliveryChannelsResult describeDeliveryChannelsResult = (DescribeDeliveryChannelsResult)response.getAwsResponse();
            return describeDeliveryChannelsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeDeliveryChannelsResult describeDeliveryChannels() {
        return this.describeDeliveryChannels(new DescribeDeliveryChannelsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetComplianceDetailsByConfigRuleResult getComplianceDetailsByConfigRule(GetComplianceDetailsByConfigRuleRequest getComplianceDetailsByConfigRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getComplianceDetailsByConfigRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetComplianceDetailsByConfigRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetComplianceDetailsByConfigRuleRequestMarshaller().marshall((GetComplianceDetailsByConfigRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)getComplianceDetailsByConfigRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new GetComplianceDetailsByConfigRuleResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetComplianceDetailsByConfigRuleResult getComplianceDetailsByConfigRuleResult = (GetComplianceDetailsByConfigRuleResult)response.getAwsResponse();
            return getComplianceDetailsByConfigRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetComplianceDetailsByResourceResult getComplianceDetailsByResource(GetComplianceDetailsByResourceRequest getComplianceDetailsByResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getComplianceDetailsByResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetComplianceDetailsByResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetComplianceDetailsByResourceRequestMarshaller().marshall((GetComplianceDetailsByResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)getComplianceDetailsByResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new GetComplianceDetailsByResourceResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetComplianceDetailsByResourceResult getComplianceDetailsByResourceResult = (GetComplianceDetailsByResourceResult)response.getAwsResponse();
            return getComplianceDetailsByResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetComplianceSummaryByConfigRuleResult getComplianceSummaryByConfigRule(GetComplianceSummaryByConfigRuleRequest getComplianceSummaryByConfigRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getComplianceSummaryByConfigRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetComplianceSummaryByConfigRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetComplianceSummaryByConfigRuleRequestMarshaller().marshall((GetComplianceSummaryByConfigRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)getComplianceSummaryByConfigRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new GetComplianceSummaryByConfigRuleResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetComplianceSummaryByConfigRuleResult getComplianceSummaryByConfigRuleResult = (GetComplianceSummaryByConfigRuleResult)response.getAwsResponse();
            return getComplianceSummaryByConfigRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetComplianceSummaryByConfigRuleResult getComplianceSummaryByConfigRule() {
        return this.getComplianceSummaryByConfigRule(new GetComplianceSummaryByConfigRuleRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetComplianceSummaryByResourceTypeResult getComplianceSummaryByResourceType(GetComplianceSummaryByResourceTypeRequest getComplianceSummaryByResourceTypeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getComplianceSummaryByResourceTypeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetComplianceSummaryByResourceTypeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetComplianceSummaryByResourceTypeRequestMarshaller().marshall((GetComplianceSummaryByResourceTypeRequest)super.beforeMarshalling((AmazonWebServiceRequest)getComplianceSummaryByResourceTypeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new GetComplianceSummaryByResourceTypeResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetComplianceSummaryByResourceTypeResult getComplianceSummaryByResourceTypeResult = (GetComplianceSummaryByResourceTypeResult)response.getAwsResponse();
            return getComplianceSummaryByResourceTypeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetComplianceSummaryByResourceTypeResult getComplianceSummaryByResourceType() {
        return this.getComplianceSummaryByResourceType(new GetComplianceSummaryByResourceTypeRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourceConfigHistoryResult getResourceConfigHistory(GetResourceConfigHistoryRequest getResourceConfigHistoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getResourceConfigHistoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetResourceConfigHistoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetResourceConfigHistoryRequestMarshaller().marshall((GetResourceConfigHistoryRequest)super.beforeMarshalling((AmazonWebServiceRequest)getResourceConfigHistoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new GetResourceConfigHistoryResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetResourceConfigHistoryResult getResourceConfigHistoryResult = (GetResourceConfigHistoryResult)response.getAwsResponse();
            return getResourceConfigHistoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDiscoveredResourcesResult listDiscoveredResources(ListDiscoveredResourcesRequest listDiscoveredResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDiscoveredResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDiscoveredResourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDiscoveredResourcesRequestMarshaller().marshall((ListDiscoveredResourcesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDiscoveredResourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new ListDiscoveredResourcesResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListDiscoveredResourcesResult listDiscoveredResourcesResult = (ListDiscoveredResourcesResult)response.getAwsResponse();
            return listDiscoveredResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putConfigRule(PutConfigRuleRequest putConfigRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putConfigRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutConfigRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutConfigRuleRequestMarshaller().marshall((PutConfigRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)putConfigRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler(null, (boolean)false);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putConfigurationRecorder(PutConfigurationRecorderRequest putConfigurationRecorderRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putConfigurationRecorderRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutConfigurationRecorderRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutConfigurationRecorderRequestMarshaller().marshall((PutConfigurationRecorderRequest)super.beforeMarshalling((AmazonWebServiceRequest)putConfigurationRecorderRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler(null, (boolean)false);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putDeliveryChannel(PutDeliveryChannelRequest putDeliveryChannelRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putDeliveryChannelRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutDeliveryChannelRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutDeliveryChannelRequestMarshaller().marshall((PutDeliveryChannelRequest)super.beforeMarshalling((AmazonWebServiceRequest)putDeliveryChannelRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler(null, (boolean)false);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutEvaluationsResult putEvaluations(PutEvaluationsRequest putEvaluationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putEvaluationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutEvaluationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutEvaluationsRequestMarshaller().marshall((PutEvaluationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)putEvaluationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new PutEvaluationsResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            PutEvaluationsResult putEvaluationsResult = (PutEvaluationsResult)response.getAwsResponse();
            return putEvaluationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startConfigurationRecorder(StartConfigurationRecorderRequest startConfigurationRecorderRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startConfigurationRecorderRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartConfigurationRecorderRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartConfigurationRecorderRequestMarshaller().marshall((StartConfigurationRecorderRequest)super.beforeMarshalling((AmazonWebServiceRequest)startConfigurationRecorderRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler(null, (boolean)false);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopConfigurationRecorder(StopConfigurationRecorderRequest stopConfigurationRecorderRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopConfigurationRecorderRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopConfigurationRecorderRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopConfigurationRecorderRequestMarshaller().marshall((StopConfigurationRecorderRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopConfigurationRecorderRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler(null, (boolean)false);
            responseHandler.setIsPayloadJson(true);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        JsonErrorResponseHandlerV2 errorResponseHandler = SdkJsonProtocolFactory.createErrorResponseHandler(this.jsonErrorUnmarshallers, (boolean)false);
        return this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
    }
}

