/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.config.model.Owner;
import com.amazonaws.services.config.model.SourceDetail;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Source
implements Serializable,
Cloneable {
    private String owner;
    private String sourceIdentifier;
    private ListWithAutoConstructFlag<SourceDetail> sourceDetails;

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Source withOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public void setOwner(Owner owner) {
        this.owner = owner.toString();
    }

    public Source withOwner(Owner owner) {
        this.owner = owner.toString();
        return this;
    }

    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public void setSourceIdentifier(String sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
    }

    public Source withSourceIdentifier(String sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
        return this;
    }

    public List<SourceDetail> getSourceDetails() {
        if (this.sourceDetails == null) {
            this.sourceDetails = new ListWithAutoConstructFlag();
            this.sourceDetails.setAutoConstruct(true);
        }
        return this.sourceDetails;
    }

    public void setSourceDetails(Collection<SourceDetail> sourceDetails) {
        if (sourceDetails == null) {
            this.sourceDetails = null;
            return;
        }
        ListWithAutoConstructFlag sourceDetailsCopy = new ListWithAutoConstructFlag(sourceDetails.size());
        sourceDetailsCopy.addAll(sourceDetails);
        this.sourceDetails = sourceDetailsCopy;
    }

    public Source withSourceDetails(SourceDetail ... sourceDetails) {
        if (this.getSourceDetails() == null) {
            this.setSourceDetails(new ArrayList<SourceDetail>(sourceDetails.length));
        }
        for (SourceDetail value : sourceDetails) {
            this.getSourceDetails().add(value);
        }
        return this;
    }

    public Source withSourceDetails(Collection<SourceDetail> sourceDetails) {
        if (sourceDetails == null) {
            this.sourceDetails = null;
        } else {
            ListWithAutoConstructFlag sourceDetailsCopy = new ListWithAutoConstructFlag(sourceDetails.size());
            sourceDetailsCopy.addAll(sourceDetails);
            this.sourceDetails = sourceDetailsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOwner() != null) {
            sb.append("Owner: " + this.getOwner() + ",");
        }
        if (this.getSourceIdentifier() != null) {
            sb.append("SourceIdentifier: " + this.getSourceIdentifier() + ",");
        }
        if (this.getSourceDetails() != null) {
            sb.append("SourceDetails: " + this.getSourceDetails());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOwner() == null ? 0 : this.getOwner().hashCode());
        hashCode = 31 * hashCode + (this.getSourceIdentifier() == null ? 0 : this.getSourceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getSourceDetails() == null ? 0 : this.getSourceDetails().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source other = (Source)obj;
        if (other.getOwner() == null ^ this.getOwner() == null) {
            return false;
        }
        if (other.getOwner() != null && !other.getOwner().equals(this.getOwner())) {
            return false;
        }
        if (other.getSourceIdentifier() == null ^ this.getSourceIdentifier() == null) {
            return false;
        }
        if (other.getSourceIdentifier() != null && !other.getSourceIdentifier().equals(this.getSourceIdentifier())) {
            return false;
        }
        if (other.getSourceDetails() == null ^ this.getSourceDetails() == null) {
            return false;
        }
        return other.getSourceDetails() == null || other.getSourceDetails().equals(this.getSourceDetails());
    }

    public Source clone() {
        try {
            return (Source)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

