/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.comprehend.model.ToxicContent;
import com.amazonaws.services.comprehend.model.transform.ToxicLabelsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ToxicLabels
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ToxicContent> labels;
    private Float toxicity;

    public List<ToxicContent> getLabels() {
        return this.labels;
    }

    public void setLabels(Collection<ToxicContent> labels) {
        if (labels == null) {
            this.labels = null;
            return;
        }
        this.labels = new ArrayList<ToxicContent>(labels);
    }

    public ToxicLabels withLabels(ToxicContent ... labels) {
        if (this.labels == null) {
            this.setLabels(new ArrayList<ToxicContent>(labels.length));
        }
        for (ToxicContent ele : labels) {
            this.labels.add(ele);
        }
        return this;
    }

    public ToxicLabels withLabels(Collection<ToxicContent> labels) {
        this.setLabels(labels);
        return this;
    }

    public void setToxicity(Float toxicity) {
        this.toxicity = toxicity;
    }

    public Float getToxicity() {
        return this.toxicity;
    }

    public ToxicLabels withToxicity(Float toxicity) {
        this.setToxicity(toxicity);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLabels() != null) {
            sb.append("Labels: ").append(this.getLabels()).append(",");
        }
        if (this.getToxicity() != null) {
            sb.append("Toxicity: ").append(this.getToxicity());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToxicLabels)) {
            return false;
        }
        ToxicLabels other = (ToxicLabels)obj;
        if (other.getLabels() == null ^ this.getLabels() == null) {
            return false;
        }
        if (other.getLabels() != null && !other.getLabels().equals(this.getLabels())) {
            return false;
        }
        if (other.getToxicity() == null ^ this.getToxicity() == null) {
            return false;
        }
        return other.getToxicity() == null || other.getToxicity().equals(this.getToxicity());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLabels() == null ? 0 : this.getLabels().hashCode());
        hashCode = 31 * hashCode + (this.getToxicity() == null ? 0 : this.getToxicity().hashCode());
        return hashCode;
    }

    public ToxicLabels clone() {
        try {
            return (ToxicLabels)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ToxicLabelsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

