/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitosync.model.SetCognitoEventsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class SetCognitoEventsRequestMarshaller
implements Marshaller<Request<SetCognitoEventsRequest>, SetCognitoEventsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public SetCognitoEventsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<SetCognitoEventsRequest> marshall(SetCognitoEventsRequest setCognitoEventsRequest) {
        if (setCognitoEventsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setCognitoEventsRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/events";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", setCognitoEventsRequest.getIdentityPoolId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)setCognitoEventsRequest.getIdentityPoolId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalMap eventsMap = (SdkInternalMap)setCognitoEventsRequest.getEvents();
            if (!eventsMap.isEmpty() || !eventsMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Events");
                jsonGenerator.writeStartObject();
                for (Map.Entry eventsMapValue : eventsMap.entrySet()) {
                    if (eventsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)eventsMapValue.getKey());
                    jsonGenerator.writeValue((String)eventsMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

