/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.GroupType;

public class GroupTypeJsonMarshaller {
    private static GroupTypeJsonMarshaller instance;

    public void marshall(GroupType groupType, StructuredJsonGenerator jsonGenerator) {
        if (groupType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (groupType.getGroupName() != null) {
                jsonGenerator.writeFieldName("GroupName").writeValue(groupType.getGroupName());
            }
            if (groupType.getUserPoolId() != null) {
                jsonGenerator.writeFieldName("UserPoolId").writeValue(groupType.getUserPoolId());
            }
            if (groupType.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(groupType.getDescription());
            }
            if (groupType.getRoleArn() != null) {
                jsonGenerator.writeFieldName("RoleArn").writeValue(groupType.getRoleArn());
            }
            if (groupType.getPrecedence() != null) {
                jsonGenerator.writeFieldName("Precedence").writeValue(groupType.getPrecedence().intValue());
            }
            if (groupType.getLastModifiedDate() != null) {
                jsonGenerator.writeFieldName("LastModifiedDate").writeValue(groupType.getLastModifiedDate());
            }
            if (groupType.getCreationDate() != null) {
                jsonGenerator.writeFieldName("CreationDate").writeValue(groupType.getCreationDate());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static GroupTypeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new GroupTypeJsonMarshaller();
        }
        return instance;
    }
}

