/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.cognitoidp.AWSCognitoIdentityProviderAsync;
import com.amazonaws.services.cognitoidp.AWSCognitoIdentityProviderClient;
import com.amazonaws.services.cognitoidp.model.AddCustomAttributesRequest;
import com.amazonaws.services.cognitoidp.model.AddCustomAttributesResult;
import com.amazonaws.services.cognitoidp.model.AdminConfirmSignUpRequest;
import com.amazonaws.services.cognitoidp.model.AdminConfirmSignUpResult;
import com.amazonaws.services.cognitoidp.model.AdminDeleteUserAttributesRequest;
import com.amazonaws.services.cognitoidp.model.AdminDeleteUserAttributesResult;
import com.amazonaws.services.cognitoidp.model.AdminDeleteUserRequest;
import com.amazonaws.services.cognitoidp.model.AdminDeleteUserResult;
import com.amazonaws.services.cognitoidp.model.AdminDisableUserRequest;
import com.amazonaws.services.cognitoidp.model.AdminDisableUserResult;
import com.amazonaws.services.cognitoidp.model.AdminEnableUserRequest;
import com.amazonaws.services.cognitoidp.model.AdminEnableUserResult;
import com.amazonaws.services.cognitoidp.model.AdminGetUserRequest;
import com.amazonaws.services.cognitoidp.model.AdminGetUserResult;
import com.amazonaws.services.cognitoidp.model.AdminResetUserPasswordRequest;
import com.amazonaws.services.cognitoidp.model.AdminResetUserPasswordResult;
import com.amazonaws.services.cognitoidp.model.AdminSetUserSettingsRequest;
import com.amazonaws.services.cognitoidp.model.AdminSetUserSettingsResult;
import com.amazonaws.services.cognitoidp.model.AdminUpdateUserAttributesRequest;
import com.amazonaws.services.cognitoidp.model.AdminUpdateUserAttributesResult;
import com.amazonaws.services.cognitoidp.model.ChangePasswordRequest;
import com.amazonaws.services.cognitoidp.model.ChangePasswordResult;
import com.amazonaws.services.cognitoidp.model.ConfirmForgotPasswordRequest;
import com.amazonaws.services.cognitoidp.model.ConfirmForgotPasswordResult;
import com.amazonaws.services.cognitoidp.model.ConfirmSignUpRequest;
import com.amazonaws.services.cognitoidp.model.ConfirmSignUpResult;
import com.amazonaws.services.cognitoidp.model.CreateUserPoolClientRequest;
import com.amazonaws.services.cognitoidp.model.CreateUserPoolClientResult;
import com.amazonaws.services.cognitoidp.model.CreateUserPoolRequest;
import com.amazonaws.services.cognitoidp.model.CreateUserPoolResult;
import com.amazonaws.services.cognitoidp.model.DeleteUserAttributesRequest;
import com.amazonaws.services.cognitoidp.model.DeleteUserAttributesResult;
import com.amazonaws.services.cognitoidp.model.DeleteUserPoolClientRequest;
import com.amazonaws.services.cognitoidp.model.DeleteUserPoolClientResult;
import com.amazonaws.services.cognitoidp.model.DeleteUserPoolRequest;
import com.amazonaws.services.cognitoidp.model.DeleteUserPoolResult;
import com.amazonaws.services.cognitoidp.model.DeleteUserRequest;
import com.amazonaws.services.cognitoidp.model.DeleteUserResult;
import com.amazonaws.services.cognitoidp.model.DescribeUserPoolClientRequest;
import com.amazonaws.services.cognitoidp.model.DescribeUserPoolClientResult;
import com.amazonaws.services.cognitoidp.model.DescribeUserPoolRequest;
import com.amazonaws.services.cognitoidp.model.DescribeUserPoolResult;
import com.amazonaws.services.cognitoidp.model.ForgotPasswordRequest;
import com.amazonaws.services.cognitoidp.model.ForgotPasswordResult;
import com.amazonaws.services.cognitoidp.model.GetUserAttributeVerificationCodeRequest;
import com.amazonaws.services.cognitoidp.model.GetUserAttributeVerificationCodeResult;
import com.amazonaws.services.cognitoidp.model.GetUserRequest;
import com.amazonaws.services.cognitoidp.model.GetUserResult;
import com.amazonaws.services.cognitoidp.model.ListUserPoolClientsRequest;
import com.amazonaws.services.cognitoidp.model.ListUserPoolClientsResult;
import com.amazonaws.services.cognitoidp.model.ListUserPoolsRequest;
import com.amazonaws.services.cognitoidp.model.ListUserPoolsResult;
import com.amazonaws.services.cognitoidp.model.ListUsersRequest;
import com.amazonaws.services.cognitoidp.model.ListUsersResult;
import com.amazonaws.services.cognitoidp.model.ResendConfirmationCodeRequest;
import com.amazonaws.services.cognitoidp.model.ResendConfirmationCodeResult;
import com.amazonaws.services.cognitoidp.model.SetUserSettingsRequest;
import com.amazonaws.services.cognitoidp.model.SetUserSettingsResult;
import com.amazonaws.services.cognitoidp.model.SignUpRequest;
import com.amazonaws.services.cognitoidp.model.SignUpResult;
import com.amazonaws.services.cognitoidp.model.UpdateUserAttributesRequest;
import com.amazonaws.services.cognitoidp.model.UpdateUserAttributesResult;
import com.amazonaws.services.cognitoidp.model.UpdateUserPoolClientRequest;
import com.amazonaws.services.cognitoidp.model.UpdateUserPoolClientResult;
import com.amazonaws.services.cognitoidp.model.UpdateUserPoolRequest;
import com.amazonaws.services.cognitoidp.model.UpdateUserPoolResult;
import com.amazonaws.services.cognitoidp.model.VerifyUserAttributeRequest;
import com.amazonaws.services.cognitoidp.model.VerifyUserAttributeResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCognitoIdentityProviderAsyncClient
extends AWSCognitoIdentityProviderClient
implements AWSCognitoIdentityProviderAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSCognitoIdentityProviderAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AWSCognitoIdentityProviderAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCognitoIdentityProviderAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSCognitoIdentityProviderAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AWSCognitoIdentityProviderAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSCognitoIdentityProviderAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSCognitoIdentityProviderAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSCognitoIdentityProviderAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AWSCognitoIdentityProviderAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AWSCognitoIdentityProviderAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddCustomAttributesResult> addCustomAttributesAsync(AddCustomAttributesRequest request) {
        return this.addCustomAttributesAsync(request, null);
    }

    @Override
    public Future<AddCustomAttributesResult> addCustomAttributesAsync(final AddCustomAttributesRequest request, final AsyncHandler<AddCustomAttributesRequest, AddCustomAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<AddCustomAttributesResult>(){

            @Override
            public AddCustomAttributesResult call() throws Exception {
                AddCustomAttributesResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.addCustomAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AdminConfirmSignUpResult> adminConfirmSignUpAsync(AdminConfirmSignUpRequest request) {
        return this.adminConfirmSignUpAsync(request, null);
    }

    @Override
    public Future<AdminConfirmSignUpResult> adminConfirmSignUpAsync(final AdminConfirmSignUpRequest request, final AsyncHandler<AdminConfirmSignUpRequest, AdminConfirmSignUpResult> asyncHandler) {
        return this.executorService.submit(new Callable<AdminConfirmSignUpResult>(){

            @Override
            public AdminConfirmSignUpResult call() throws Exception {
                AdminConfirmSignUpResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.adminConfirmSignUp(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AdminDeleteUserResult> adminDeleteUserAsync(AdminDeleteUserRequest request) {
        return this.adminDeleteUserAsync(request, null);
    }

    @Override
    public Future<AdminDeleteUserResult> adminDeleteUserAsync(final AdminDeleteUserRequest request, final AsyncHandler<AdminDeleteUserRequest, AdminDeleteUserResult> asyncHandler) {
        return this.executorService.submit(new Callable<AdminDeleteUserResult>(){

            @Override
            public AdminDeleteUserResult call() throws Exception {
                AdminDeleteUserResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.adminDeleteUser(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AdminDeleteUserAttributesResult> adminDeleteUserAttributesAsync(AdminDeleteUserAttributesRequest request) {
        return this.adminDeleteUserAttributesAsync(request, null);
    }

    @Override
    public Future<AdminDeleteUserAttributesResult> adminDeleteUserAttributesAsync(final AdminDeleteUserAttributesRequest request, final AsyncHandler<AdminDeleteUserAttributesRequest, AdminDeleteUserAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<AdminDeleteUserAttributesResult>(){

            @Override
            public AdminDeleteUserAttributesResult call() throws Exception {
                AdminDeleteUserAttributesResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.adminDeleteUserAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AdminDisableUserResult> adminDisableUserAsync(AdminDisableUserRequest request) {
        return this.adminDisableUserAsync(request, null);
    }

    @Override
    public Future<AdminDisableUserResult> adminDisableUserAsync(final AdminDisableUserRequest request, final AsyncHandler<AdminDisableUserRequest, AdminDisableUserResult> asyncHandler) {
        return this.executorService.submit(new Callable<AdminDisableUserResult>(){

            @Override
            public AdminDisableUserResult call() throws Exception {
                AdminDisableUserResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.adminDisableUser(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AdminEnableUserResult> adminEnableUserAsync(AdminEnableUserRequest request) {
        return this.adminEnableUserAsync(request, null);
    }

    @Override
    public Future<AdminEnableUserResult> adminEnableUserAsync(final AdminEnableUserRequest request, final AsyncHandler<AdminEnableUserRequest, AdminEnableUserResult> asyncHandler) {
        return this.executorService.submit(new Callable<AdminEnableUserResult>(){

            @Override
            public AdminEnableUserResult call() throws Exception {
                AdminEnableUserResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.adminEnableUser(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AdminGetUserResult> adminGetUserAsync(AdminGetUserRequest request) {
        return this.adminGetUserAsync(request, null);
    }

    @Override
    public Future<AdminGetUserResult> adminGetUserAsync(final AdminGetUserRequest request, final AsyncHandler<AdminGetUserRequest, AdminGetUserResult> asyncHandler) {
        return this.executorService.submit(new Callable<AdminGetUserResult>(){

            @Override
            public AdminGetUserResult call() throws Exception {
                AdminGetUserResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.adminGetUser(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AdminResetUserPasswordResult> adminResetUserPasswordAsync(AdminResetUserPasswordRequest request) {
        return this.adminResetUserPasswordAsync(request, null);
    }

    @Override
    public Future<AdminResetUserPasswordResult> adminResetUserPasswordAsync(final AdminResetUserPasswordRequest request, final AsyncHandler<AdminResetUserPasswordRequest, AdminResetUserPasswordResult> asyncHandler) {
        return this.executorService.submit(new Callable<AdminResetUserPasswordResult>(){

            @Override
            public AdminResetUserPasswordResult call() throws Exception {
                AdminResetUserPasswordResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.adminResetUserPassword(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AdminSetUserSettingsResult> adminSetUserSettingsAsync(AdminSetUserSettingsRequest request) {
        return this.adminSetUserSettingsAsync(request, null);
    }

    @Override
    public Future<AdminSetUserSettingsResult> adminSetUserSettingsAsync(final AdminSetUserSettingsRequest request, final AsyncHandler<AdminSetUserSettingsRequest, AdminSetUserSettingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<AdminSetUserSettingsResult>(){

            @Override
            public AdminSetUserSettingsResult call() throws Exception {
                AdminSetUserSettingsResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.adminSetUserSettings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AdminUpdateUserAttributesResult> adminUpdateUserAttributesAsync(AdminUpdateUserAttributesRequest request) {
        return this.adminUpdateUserAttributesAsync(request, null);
    }

    @Override
    public Future<AdminUpdateUserAttributesResult> adminUpdateUserAttributesAsync(final AdminUpdateUserAttributesRequest request, final AsyncHandler<AdminUpdateUserAttributesRequest, AdminUpdateUserAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<AdminUpdateUserAttributesResult>(){

            @Override
            public AdminUpdateUserAttributesResult call() throws Exception {
                AdminUpdateUserAttributesResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.adminUpdateUserAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ChangePasswordResult> changePasswordAsync(ChangePasswordRequest request) {
        return this.changePasswordAsync(request, null);
    }

    @Override
    public Future<ChangePasswordResult> changePasswordAsync(final ChangePasswordRequest request, final AsyncHandler<ChangePasswordRequest, ChangePasswordResult> asyncHandler) {
        return this.executorService.submit(new Callable<ChangePasswordResult>(){

            @Override
            public ChangePasswordResult call() throws Exception {
                ChangePasswordResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.changePassword(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ConfirmForgotPasswordResult> confirmForgotPasswordAsync(ConfirmForgotPasswordRequest request) {
        return this.confirmForgotPasswordAsync(request, null);
    }

    @Override
    public Future<ConfirmForgotPasswordResult> confirmForgotPasswordAsync(final ConfirmForgotPasswordRequest request, final AsyncHandler<ConfirmForgotPasswordRequest, ConfirmForgotPasswordResult> asyncHandler) {
        return this.executorService.submit(new Callable<ConfirmForgotPasswordResult>(){

            @Override
            public ConfirmForgotPasswordResult call() throws Exception {
                ConfirmForgotPasswordResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.confirmForgotPassword(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ConfirmSignUpResult> confirmSignUpAsync(ConfirmSignUpRequest request) {
        return this.confirmSignUpAsync(request, null);
    }

    @Override
    public Future<ConfirmSignUpResult> confirmSignUpAsync(final ConfirmSignUpRequest request, final AsyncHandler<ConfirmSignUpRequest, ConfirmSignUpResult> asyncHandler) {
        return this.executorService.submit(new Callable<ConfirmSignUpResult>(){

            @Override
            public ConfirmSignUpResult call() throws Exception {
                ConfirmSignUpResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.confirmSignUp(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateUserPoolResult> createUserPoolAsync(CreateUserPoolRequest request) {
        return this.createUserPoolAsync(request, null);
    }

    @Override
    public Future<CreateUserPoolResult> createUserPoolAsync(final CreateUserPoolRequest request, final AsyncHandler<CreateUserPoolRequest, CreateUserPoolResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateUserPoolResult>(){

            @Override
            public CreateUserPoolResult call() throws Exception {
                CreateUserPoolResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.createUserPool(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateUserPoolClientResult> createUserPoolClientAsync(CreateUserPoolClientRequest request) {
        return this.createUserPoolClientAsync(request, null);
    }

    @Override
    public Future<CreateUserPoolClientResult> createUserPoolClientAsync(final CreateUserPoolClientRequest request, final AsyncHandler<CreateUserPoolClientRequest, CreateUserPoolClientResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateUserPoolClientResult>(){

            @Override
            public CreateUserPoolClientResult call() throws Exception {
                CreateUserPoolClientResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.createUserPoolClient(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteUserResult> deleteUserAsync(DeleteUserRequest request) {
        return this.deleteUserAsync(request, null);
    }

    @Override
    public Future<DeleteUserResult> deleteUserAsync(final DeleteUserRequest request, final AsyncHandler<DeleteUserRequest, DeleteUserResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteUserResult>(){

            @Override
            public DeleteUserResult call() throws Exception {
                DeleteUserResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.deleteUser(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteUserAttributesResult> deleteUserAttributesAsync(DeleteUserAttributesRequest request) {
        return this.deleteUserAttributesAsync(request, null);
    }

    @Override
    public Future<DeleteUserAttributesResult> deleteUserAttributesAsync(final DeleteUserAttributesRequest request, final AsyncHandler<DeleteUserAttributesRequest, DeleteUserAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteUserAttributesResult>(){

            @Override
            public DeleteUserAttributesResult call() throws Exception {
                DeleteUserAttributesResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.deleteUserAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteUserPoolResult> deleteUserPoolAsync(DeleteUserPoolRequest request) {
        return this.deleteUserPoolAsync(request, null);
    }

    @Override
    public Future<DeleteUserPoolResult> deleteUserPoolAsync(final DeleteUserPoolRequest request, final AsyncHandler<DeleteUserPoolRequest, DeleteUserPoolResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteUserPoolResult>(){

            @Override
            public DeleteUserPoolResult call() throws Exception {
                DeleteUserPoolResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.deleteUserPool(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteUserPoolClientResult> deleteUserPoolClientAsync(DeleteUserPoolClientRequest request) {
        return this.deleteUserPoolClientAsync(request, null);
    }

    @Override
    public Future<DeleteUserPoolClientResult> deleteUserPoolClientAsync(final DeleteUserPoolClientRequest request, final AsyncHandler<DeleteUserPoolClientRequest, DeleteUserPoolClientResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteUserPoolClientResult>(){

            @Override
            public DeleteUserPoolClientResult call() throws Exception {
                DeleteUserPoolClientResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.deleteUserPoolClient(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeUserPoolResult> describeUserPoolAsync(DescribeUserPoolRequest request) {
        return this.describeUserPoolAsync(request, null);
    }

    @Override
    public Future<DescribeUserPoolResult> describeUserPoolAsync(final DescribeUserPoolRequest request, final AsyncHandler<DescribeUserPoolRequest, DescribeUserPoolResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeUserPoolResult>(){

            @Override
            public DescribeUserPoolResult call() throws Exception {
                DescribeUserPoolResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.describeUserPool(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeUserPoolClientResult> describeUserPoolClientAsync(DescribeUserPoolClientRequest request) {
        return this.describeUserPoolClientAsync(request, null);
    }

    @Override
    public Future<DescribeUserPoolClientResult> describeUserPoolClientAsync(final DescribeUserPoolClientRequest request, final AsyncHandler<DescribeUserPoolClientRequest, DescribeUserPoolClientResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeUserPoolClientResult>(){

            @Override
            public DescribeUserPoolClientResult call() throws Exception {
                DescribeUserPoolClientResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.describeUserPoolClient(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ForgotPasswordResult> forgotPasswordAsync(ForgotPasswordRequest request) {
        return this.forgotPasswordAsync(request, null);
    }

    @Override
    public Future<ForgotPasswordResult> forgotPasswordAsync(final ForgotPasswordRequest request, final AsyncHandler<ForgotPasswordRequest, ForgotPasswordResult> asyncHandler) {
        return this.executorService.submit(new Callable<ForgotPasswordResult>(){

            @Override
            public ForgotPasswordResult call() throws Exception {
                ForgotPasswordResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.forgotPassword(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetUserResult> getUserAsync(GetUserRequest request) {
        return this.getUserAsync(request, null);
    }

    @Override
    public Future<GetUserResult> getUserAsync(final GetUserRequest request, final AsyncHandler<GetUserRequest, GetUserResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetUserResult>(){

            @Override
            public GetUserResult call() throws Exception {
                GetUserResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.getUser(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetUserAttributeVerificationCodeResult> getUserAttributeVerificationCodeAsync(GetUserAttributeVerificationCodeRequest request) {
        return this.getUserAttributeVerificationCodeAsync(request, null);
    }

    @Override
    public Future<GetUserAttributeVerificationCodeResult> getUserAttributeVerificationCodeAsync(final GetUserAttributeVerificationCodeRequest request, final AsyncHandler<GetUserAttributeVerificationCodeRequest, GetUserAttributeVerificationCodeResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetUserAttributeVerificationCodeResult>(){

            @Override
            public GetUserAttributeVerificationCodeResult call() throws Exception {
                GetUserAttributeVerificationCodeResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.getUserAttributeVerificationCode(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUserPoolClientsResult> listUserPoolClientsAsync(ListUserPoolClientsRequest request) {
        return this.listUserPoolClientsAsync(request, null);
    }

    @Override
    public Future<ListUserPoolClientsResult> listUserPoolClientsAsync(final ListUserPoolClientsRequest request, final AsyncHandler<ListUserPoolClientsRequest, ListUserPoolClientsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListUserPoolClientsResult>(){

            @Override
            public ListUserPoolClientsResult call() throws Exception {
                ListUserPoolClientsResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.listUserPoolClients(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUserPoolsResult> listUserPoolsAsync(ListUserPoolsRequest request) {
        return this.listUserPoolsAsync(request, null);
    }

    @Override
    public Future<ListUserPoolsResult> listUserPoolsAsync(final ListUserPoolsRequest request, final AsyncHandler<ListUserPoolsRequest, ListUserPoolsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListUserPoolsResult>(){

            @Override
            public ListUserPoolsResult call() throws Exception {
                ListUserPoolsResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.listUserPools(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListUsersResult> listUsersAsync(ListUsersRequest request) {
        return this.listUsersAsync(request, null);
    }

    @Override
    public Future<ListUsersResult> listUsersAsync(final ListUsersRequest request, final AsyncHandler<ListUsersRequest, ListUsersResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListUsersResult>(){

            @Override
            public ListUsersResult call() throws Exception {
                ListUsersResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.listUsers(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ResendConfirmationCodeResult> resendConfirmationCodeAsync(ResendConfirmationCodeRequest request) {
        return this.resendConfirmationCodeAsync(request, null);
    }

    @Override
    public Future<ResendConfirmationCodeResult> resendConfirmationCodeAsync(final ResendConfirmationCodeRequest request, final AsyncHandler<ResendConfirmationCodeRequest, ResendConfirmationCodeResult> asyncHandler) {
        return this.executorService.submit(new Callable<ResendConfirmationCodeResult>(){

            @Override
            public ResendConfirmationCodeResult call() throws Exception {
                ResendConfirmationCodeResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.resendConfirmationCode(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetUserSettingsResult> setUserSettingsAsync(SetUserSettingsRequest request) {
        return this.setUserSettingsAsync(request, null);
    }

    @Override
    public Future<SetUserSettingsResult> setUserSettingsAsync(final SetUserSettingsRequest request, final AsyncHandler<SetUserSettingsRequest, SetUserSettingsResult> asyncHandler) {
        return this.executorService.submit(new Callable<SetUserSettingsResult>(){

            @Override
            public SetUserSettingsResult call() throws Exception {
                SetUserSettingsResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.setUserSettings(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SignUpResult> signUpAsync(SignUpRequest request) {
        return this.signUpAsync(request, null);
    }

    @Override
    public Future<SignUpResult> signUpAsync(final SignUpRequest request, final AsyncHandler<SignUpRequest, SignUpResult> asyncHandler) {
        return this.executorService.submit(new Callable<SignUpResult>(){

            @Override
            public SignUpResult call() throws Exception {
                SignUpResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.signUp(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateUserAttributesResult> updateUserAttributesAsync(UpdateUserAttributesRequest request) {
        return this.updateUserAttributesAsync(request, null);
    }

    @Override
    public Future<UpdateUserAttributesResult> updateUserAttributesAsync(final UpdateUserAttributesRequest request, final AsyncHandler<UpdateUserAttributesRequest, UpdateUserAttributesResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateUserAttributesResult>(){

            @Override
            public UpdateUserAttributesResult call() throws Exception {
                UpdateUserAttributesResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.updateUserAttributes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateUserPoolResult> updateUserPoolAsync(UpdateUserPoolRequest request) {
        return this.updateUserPoolAsync(request, null);
    }

    @Override
    public Future<UpdateUserPoolResult> updateUserPoolAsync(final UpdateUserPoolRequest request, final AsyncHandler<UpdateUserPoolRequest, UpdateUserPoolResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateUserPoolResult>(){

            @Override
            public UpdateUserPoolResult call() throws Exception {
                UpdateUserPoolResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.updateUserPool(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateUserPoolClientResult> updateUserPoolClientAsync(UpdateUserPoolClientRequest request) {
        return this.updateUserPoolClientAsync(request, null);
    }

    @Override
    public Future<UpdateUserPoolClientResult> updateUserPoolClientAsync(final UpdateUserPoolClientRequest request, final AsyncHandler<UpdateUserPoolClientRequest, UpdateUserPoolClientResult> asyncHandler) {
        return this.executorService.submit(new Callable<UpdateUserPoolClientResult>(){

            @Override
            public UpdateUserPoolClientResult call() throws Exception {
                UpdateUserPoolClientResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.updateUserPoolClient(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<VerifyUserAttributeResult> verifyUserAttributeAsync(VerifyUserAttributeRequest request) {
        return this.verifyUserAttributeAsync(request, null);
    }

    @Override
    public Future<VerifyUserAttributeResult> verifyUserAttributeAsync(final VerifyUserAttributeRequest request, final AsyncHandler<VerifyUserAttributeRequest, VerifyUserAttributeResult> asyncHandler) {
        return this.executorService.submit(new Callable<VerifyUserAttributeResult>(){

            @Override
            public VerifyUserAttributeResult call() throws Exception {
                VerifyUserAttributeResult result;
                try {
                    result = AWSCognitoIdentityProviderAsyncClient.this.verifyUserAttribute(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

