/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cognitoidp.model.AdminCreateUserConfigType;
import com.amazonaws.services.cognitoidp.model.DeviceConfigurationType;
import com.amazonaws.services.cognitoidp.model.EmailConfigurationType;
import com.amazonaws.services.cognitoidp.model.LambdaConfigType;
import com.amazonaws.services.cognitoidp.model.SmsConfigurationType;
import com.amazonaws.services.cognitoidp.model.UserPoolMfaType;
import com.amazonaws.services.cognitoidp.model.UserPoolPolicyType;
import com.amazonaws.services.cognitoidp.model.VerificationMessageTemplateType;
import com.amazonaws.services.cognitoidp.model.VerifiedAttributeType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateUserPoolRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String userPoolId;
    private UserPoolPolicyType policies;
    private LambdaConfigType lambdaConfig;
    private List<String> autoVerifiedAttributes;
    private String smsVerificationMessage;
    private String emailVerificationMessage;
    private String emailVerificationSubject;
    private VerificationMessageTemplateType verificationMessageTemplate;
    private String smsAuthenticationMessage;
    private String mfaConfiguration;
    private DeviceConfigurationType deviceConfiguration;
    private EmailConfigurationType emailConfiguration;
    private SmsConfigurationType smsConfiguration;
    private Map<String, String> userPoolTags;
    private AdminCreateUserConfigType adminCreateUserConfig;

    public void setUserPoolId(String userPoolId) {
        this.userPoolId = userPoolId;
    }

    public String getUserPoolId() {
        return this.userPoolId;
    }

    public UpdateUserPoolRequest withUserPoolId(String userPoolId) {
        this.setUserPoolId(userPoolId);
        return this;
    }

    public void setPolicies(UserPoolPolicyType policies) {
        this.policies = policies;
    }

    public UserPoolPolicyType getPolicies() {
        return this.policies;
    }

    public UpdateUserPoolRequest withPolicies(UserPoolPolicyType policies) {
        this.setPolicies(policies);
        return this;
    }

    public void setLambdaConfig(LambdaConfigType lambdaConfig) {
        this.lambdaConfig = lambdaConfig;
    }

    public LambdaConfigType getLambdaConfig() {
        return this.lambdaConfig;
    }

    public UpdateUserPoolRequest withLambdaConfig(LambdaConfigType lambdaConfig) {
        this.setLambdaConfig(lambdaConfig);
        return this;
    }

    public List<String> getAutoVerifiedAttributes() {
        return this.autoVerifiedAttributes;
    }

    public void setAutoVerifiedAttributes(Collection<String> autoVerifiedAttributes) {
        if (autoVerifiedAttributes == null) {
            this.autoVerifiedAttributes = null;
            return;
        }
        this.autoVerifiedAttributes = new ArrayList<String>(autoVerifiedAttributes);
    }

    public UpdateUserPoolRequest withAutoVerifiedAttributes(String ... autoVerifiedAttributes) {
        if (this.autoVerifiedAttributes == null) {
            this.setAutoVerifiedAttributes(new ArrayList<String>(autoVerifiedAttributes.length));
        }
        for (String ele : autoVerifiedAttributes) {
            this.autoVerifiedAttributes.add(ele);
        }
        return this;
    }

    public UpdateUserPoolRequest withAutoVerifiedAttributes(Collection<String> autoVerifiedAttributes) {
        this.setAutoVerifiedAttributes(autoVerifiedAttributes);
        return this;
    }

    public UpdateUserPoolRequest withAutoVerifiedAttributes(VerifiedAttributeType ... autoVerifiedAttributes) {
        ArrayList<String> autoVerifiedAttributesCopy = new ArrayList<String>(autoVerifiedAttributes.length);
        for (VerifiedAttributeType value : autoVerifiedAttributes) {
            autoVerifiedAttributesCopy.add(value.toString());
        }
        if (this.getAutoVerifiedAttributes() == null) {
            this.setAutoVerifiedAttributes(autoVerifiedAttributesCopy);
        } else {
            this.getAutoVerifiedAttributes().addAll(autoVerifiedAttributesCopy);
        }
        return this;
    }

    public void setSmsVerificationMessage(String smsVerificationMessage) {
        this.smsVerificationMessage = smsVerificationMessage;
    }

    public String getSmsVerificationMessage() {
        return this.smsVerificationMessage;
    }

    public UpdateUserPoolRequest withSmsVerificationMessage(String smsVerificationMessage) {
        this.setSmsVerificationMessage(smsVerificationMessage);
        return this;
    }

    public void setEmailVerificationMessage(String emailVerificationMessage) {
        this.emailVerificationMessage = emailVerificationMessage;
    }

    public String getEmailVerificationMessage() {
        return this.emailVerificationMessage;
    }

    public UpdateUserPoolRequest withEmailVerificationMessage(String emailVerificationMessage) {
        this.setEmailVerificationMessage(emailVerificationMessage);
        return this;
    }

    public void setEmailVerificationSubject(String emailVerificationSubject) {
        this.emailVerificationSubject = emailVerificationSubject;
    }

    public String getEmailVerificationSubject() {
        return this.emailVerificationSubject;
    }

    public UpdateUserPoolRequest withEmailVerificationSubject(String emailVerificationSubject) {
        this.setEmailVerificationSubject(emailVerificationSubject);
        return this;
    }

    public void setVerificationMessageTemplate(VerificationMessageTemplateType verificationMessageTemplate) {
        this.verificationMessageTemplate = verificationMessageTemplate;
    }

    public VerificationMessageTemplateType getVerificationMessageTemplate() {
        return this.verificationMessageTemplate;
    }

    public UpdateUserPoolRequest withVerificationMessageTemplate(VerificationMessageTemplateType verificationMessageTemplate) {
        this.setVerificationMessageTemplate(verificationMessageTemplate);
        return this;
    }

    public void setSmsAuthenticationMessage(String smsAuthenticationMessage) {
        this.smsAuthenticationMessage = smsAuthenticationMessage;
    }

    public String getSmsAuthenticationMessage() {
        return this.smsAuthenticationMessage;
    }

    public UpdateUserPoolRequest withSmsAuthenticationMessage(String smsAuthenticationMessage) {
        this.setSmsAuthenticationMessage(smsAuthenticationMessage);
        return this;
    }

    public void setMfaConfiguration(String mfaConfiguration) {
        this.mfaConfiguration = mfaConfiguration;
    }

    @JsonProperty(value="mfaConfiguration")
    public String getMfaConfiguration() {
        return this.mfaConfiguration;
    }

    public UpdateUserPoolRequest withMfaConfiguration(String mfaConfiguration) {
        this.setMfaConfiguration(mfaConfiguration);
        return this;
    }

    @JsonIgnore
    public void setMfaConfiguration(UserPoolMfaType mfaConfiguration) {
        this.withMfaConfiguration(mfaConfiguration);
    }

    public UpdateUserPoolRequest withMfaConfiguration(UserPoolMfaType mfaConfiguration) {
        this.mfaConfiguration = mfaConfiguration.toString();
        return this;
    }

    public void setDeviceConfiguration(DeviceConfigurationType deviceConfiguration) {
        this.deviceConfiguration = deviceConfiguration;
    }

    public DeviceConfigurationType getDeviceConfiguration() {
        return this.deviceConfiguration;
    }

    public UpdateUserPoolRequest withDeviceConfiguration(DeviceConfigurationType deviceConfiguration) {
        this.setDeviceConfiguration(deviceConfiguration);
        return this;
    }

    public void setEmailConfiguration(EmailConfigurationType emailConfiguration) {
        this.emailConfiguration = emailConfiguration;
    }

    public EmailConfigurationType getEmailConfiguration() {
        return this.emailConfiguration;
    }

    public UpdateUserPoolRequest withEmailConfiguration(EmailConfigurationType emailConfiguration) {
        this.setEmailConfiguration(emailConfiguration);
        return this;
    }

    public void setSmsConfiguration(SmsConfigurationType smsConfiguration) {
        this.smsConfiguration = smsConfiguration;
    }

    public SmsConfigurationType getSmsConfiguration() {
        return this.smsConfiguration;
    }

    public UpdateUserPoolRequest withSmsConfiguration(SmsConfigurationType smsConfiguration) {
        this.setSmsConfiguration(smsConfiguration);
        return this;
    }

    public Map<String, String> getUserPoolTags() {
        return this.userPoolTags;
    }

    public void setUserPoolTags(Map<String, String> userPoolTags) {
        this.userPoolTags = userPoolTags;
    }

    public UpdateUserPoolRequest withUserPoolTags(Map<String, String> userPoolTags) {
        this.setUserPoolTags(userPoolTags);
        return this;
    }

    public UpdateUserPoolRequest addUserPoolTagsEntry(String key, String value) {
        if (null == this.userPoolTags) {
            this.userPoolTags = new HashMap<String, String>();
        }
        if (this.userPoolTags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.userPoolTags.put(key, value);
        return this;
    }

    public UpdateUserPoolRequest clearUserPoolTagsEntries() {
        this.userPoolTags = null;
        return this;
    }

    public void setAdminCreateUserConfig(AdminCreateUserConfigType adminCreateUserConfig) {
        this.adminCreateUserConfig = adminCreateUserConfig;
    }

    public AdminCreateUserConfigType getAdminCreateUserConfig() {
        return this.adminCreateUserConfig;
    }

    public UpdateUserPoolRequest withAdminCreateUserConfig(AdminCreateUserConfigType adminCreateUserConfig) {
        this.setAdminCreateUserConfig(adminCreateUserConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserPoolId() != null) {
            sb.append("UserPoolId: ").append(this.getUserPoolId()).append(",");
        }
        if (this.getPolicies() != null) {
            sb.append("Policies: ").append(this.getPolicies()).append(",");
        }
        if (this.getLambdaConfig() != null) {
            sb.append("LambdaConfig: ").append(this.getLambdaConfig()).append(",");
        }
        if (this.getAutoVerifiedAttributes() != null) {
            sb.append("AutoVerifiedAttributes: ").append(this.getAutoVerifiedAttributes()).append(",");
        }
        if (this.getSmsVerificationMessage() != null) {
            sb.append("SmsVerificationMessage: ").append(this.getSmsVerificationMessage()).append(",");
        }
        if (this.getEmailVerificationMessage() != null) {
            sb.append("EmailVerificationMessage: ").append(this.getEmailVerificationMessage()).append(",");
        }
        if (this.getEmailVerificationSubject() != null) {
            sb.append("EmailVerificationSubject: ").append(this.getEmailVerificationSubject()).append(",");
        }
        if (this.getVerificationMessageTemplate() != null) {
            sb.append("VerificationMessageTemplate: ").append(this.getVerificationMessageTemplate()).append(",");
        }
        if (this.getSmsAuthenticationMessage() != null) {
            sb.append("SmsAuthenticationMessage: ").append(this.getSmsAuthenticationMessage()).append(",");
        }
        if (this.getMfaConfiguration() != null) {
            sb.append("MfaConfiguration: ").append(this.getMfaConfiguration()).append(",");
        }
        if (this.getDeviceConfiguration() != null) {
            sb.append("DeviceConfiguration: ").append(this.getDeviceConfiguration()).append(",");
        }
        if (this.getEmailConfiguration() != null) {
            sb.append("EmailConfiguration: ").append(this.getEmailConfiguration()).append(",");
        }
        if (this.getSmsConfiguration() != null) {
            sb.append("SmsConfiguration: ").append(this.getSmsConfiguration()).append(",");
        }
        if (this.getUserPoolTags() != null) {
            sb.append("UserPoolTags: ").append(this.getUserPoolTags()).append(",");
        }
        if (this.getAdminCreateUserConfig() != null) {
            sb.append("AdminCreateUserConfig: ").append(this.getAdminCreateUserConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserPoolRequest)) {
            return false;
        }
        UpdateUserPoolRequest other = (UpdateUserPoolRequest)obj;
        if (other.getUserPoolId() == null ^ this.getUserPoolId() == null) {
            return false;
        }
        if (other.getUserPoolId() != null && !other.getUserPoolId().equals(this.getUserPoolId())) {
            return false;
        }
        if (other.getPolicies() == null ^ this.getPolicies() == null) {
            return false;
        }
        if (other.getPolicies() != null && !other.getPolicies().equals(this.getPolicies())) {
            return false;
        }
        if (other.getLambdaConfig() == null ^ this.getLambdaConfig() == null) {
            return false;
        }
        if (other.getLambdaConfig() != null && !other.getLambdaConfig().equals(this.getLambdaConfig())) {
            return false;
        }
        if (other.getAutoVerifiedAttributes() == null ^ this.getAutoVerifiedAttributes() == null) {
            return false;
        }
        if (other.getAutoVerifiedAttributes() != null && !other.getAutoVerifiedAttributes().equals(this.getAutoVerifiedAttributes())) {
            return false;
        }
        if (other.getSmsVerificationMessage() == null ^ this.getSmsVerificationMessage() == null) {
            return false;
        }
        if (other.getSmsVerificationMessage() != null && !other.getSmsVerificationMessage().equals(this.getSmsVerificationMessage())) {
            return false;
        }
        if (other.getEmailVerificationMessage() == null ^ this.getEmailVerificationMessage() == null) {
            return false;
        }
        if (other.getEmailVerificationMessage() != null && !other.getEmailVerificationMessage().equals(this.getEmailVerificationMessage())) {
            return false;
        }
        if (other.getEmailVerificationSubject() == null ^ this.getEmailVerificationSubject() == null) {
            return false;
        }
        if (other.getEmailVerificationSubject() != null && !other.getEmailVerificationSubject().equals(this.getEmailVerificationSubject())) {
            return false;
        }
        if (other.getVerificationMessageTemplate() == null ^ this.getVerificationMessageTemplate() == null) {
            return false;
        }
        if (other.getVerificationMessageTemplate() != null && !other.getVerificationMessageTemplate().equals(this.getVerificationMessageTemplate())) {
            return false;
        }
        if (other.getSmsAuthenticationMessage() == null ^ this.getSmsAuthenticationMessage() == null) {
            return false;
        }
        if (other.getSmsAuthenticationMessage() != null && !other.getSmsAuthenticationMessage().equals(this.getSmsAuthenticationMessage())) {
            return false;
        }
        if (other.getMfaConfiguration() == null ^ this.getMfaConfiguration() == null) {
            return false;
        }
        if (other.getMfaConfiguration() != null && !other.getMfaConfiguration().equals(this.getMfaConfiguration())) {
            return false;
        }
        if (other.getDeviceConfiguration() == null ^ this.getDeviceConfiguration() == null) {
            return false;
        }
        if (other.getDeviceConfiguration() != null && !other.getDeviceConfiguration().equals(this.getDeviceConfiguration())) {
            return false;
        }
        if (other.getEmailConfiguration() == null ^ this.getEmailConfiguration() == null) {
            return false;
        }
        if (other.getEmailConfiguration() != null && !other.getEmailConfiguration().equals(this.getEmailConfiguration())) {
            return false;
        }
        if (other.getSmsConfiguration() == null ^ this.getSmsConfiguration() == null) {
            return false;
        }
        if (other.getSmsConfiguration() != null && !other.getSmsConfiguration().equals(this.getSmsConfiguration())) {
            return false;
        }
        if (other.getUserPoolTags() == null ^ this.getUserPoolTags() == null) {
            return false;
        }
        if (other.getUserPoolTags() != null && !other.getUserPoolTags().equals(this.getUserPoolTags())) {
            return false;
        }
        if (other.getAdminCreateUserConfig() == null ^ this.getAdminCreateUserConfig() == null) {
            return false;
        }
        return other.getAdminCreateUserConfig() == null || other.getAdminCreateUserConfig().equals(this.getAdminCreateUserConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserPoolId() == null ? 0 : this.getUserPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getPolicies() == null ? 0 : this.getPolicies().hashCode());
        hashCode = 31 * hashCode + (this.getLambdaConfig() == null ? 0 : this.getLambdaConfig().hashCode());
        hashCode = 31 * hashCode + (this.getAutoVerifiedAttributes() == null ? 0 : this.getAutoVerifiedAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getSmsVerificationMessage() == null ? 0 : this.getSmsVerificationMessage().hashCode());
        hashCode = 31 * hashCode + (this.getEmailVerificationMessage() == null ? 0 : this.getEmailVerificationMessage().hashCode());
        hashCode = 31 * hashCode + (this.getEmailVerificationSubject() == null ? 0 : this.getEmailVerificationSubject().hashCode());
        hashCode = 31 * hashCode + (this.getVerificationMessageTemplate() == null ? 0 : this.getVerificationMessageTemplate().hashCode());
        hashCode = 31 * hashCode + (this.getSmsAuthenticationMessage() == null ? 0 : this.getSmsAuthenticationMessage().hashCode());
        hashCode = 31 * hashCode + (this.getMfaConfiguration() == null ? 0 : this.getMfaConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getDeviceConfiguration() == null ? 0 : this.getDeviceConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getEmailConfiguration() == null ? 0 : this.getEmailConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getSmsConfiguration() == null ? 0 : this.getSmsConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getUserPoolTags() == null ? 0 : this.getUserPoolTags().hashCode());
        hashCode = 31 * hashCode + (this.getAdminCreateUserConfig() == null ? 0 : this.getAdminCreateUserConfig().hashCode());
        return hashCode;
    }

    public UpdateUserPoolRequest clone() {
        return (UpdateUserPoolRequest)super.clone();
    }
}

