/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.cognitoidp.model.KeyType;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class KeyTypeJsonMarshaller {
    private static KeyTypeJsonMarshaller instance;

    public void marshall(KeyType keyType, StructuredJsonGenerator jsonGenerator) {
        if (keyType == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (keyType.getKty() != null) {
                jsonGenerator.writeFieldName("kty").writeValue(keyType.getKty());
            }
            if (keyType.getAlg() != null) {
                jsonGenerator.writeFieldName("alg").writeValue(keyType.getAlg());
            }
            if (keyType.getUse() != null) {
                jsonGenerator.writeFieldName("use").writeValue(keyType.getUse());
            }
            if (keyType.getKid() != null) {
                jsonGenerator.writeFieldName("kid").writeValue(keyType.getKid());
            }
            if (keyType.getN() != null) {
                jsonGenerator.writeFieldName("n").writeValue(keyType.getN());
            }
            if (keyType.getE() != null) {
                jsonGenerator.writeFieldName("e").writeValue(keyType.getE());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static KeyTypeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new KeyTypeJsonMarshaller();
        }
        return instance;
    }
}

