/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidentity.model.MappingRule;
import com.amazonaws.services.cognitoidentity.model.RulesConfigurationType;
import com.amazonaws.services.cognitoidentity.model.transform.MappingRuleJsonMarshaller;
import java.util.List;

public class RulesConfigurationTypeJsonMarshaller {
    private static RulesConfigurationTypeJsonMarshaller instance;

    public void marshall(RulesConfigurationType rulesConfigurationType, StructuredJsonGenerator jsonGenerator) {
        if (rulesConfigurationType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            List<MappingRule> rulesList = rulesConfigurationType.getRules();
            if (rulesList != null) {
                jsonGenerator.writeFieldName("Rules");
                jsonGenerator.writeStartArray();
                for (MappingRule rulesListValue : rulesList) {
                    if (rulesListValue == null) continue;
                    MappingRuleJsonMarshaller.getInstance().marshall(rulesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RulesConfigurationTypeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RulesConfigurationTypeJsonMarshaller();
        }
        return instance;
    }
}

