/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.codegurureviewer.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Information about an Amazon Web Services CodeCommit repository. The CodeCommit repository must be in the same Amazon
 * Web Services Region and Amazon Web Services account where its CodeGuru Reviewer code reviews are configured.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/CodeCommitRepository"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CodeCommitRepository implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of the Amazon Web Services CodeCommit repository. For more information, see <a href=
     * "https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetRepository.html#CodeCommit-GetRepository-request-repositoryName"
     * >repositoryName</a> in the <i>Amazon Web Services CodeCommit API Reference</i>.
     * </p>
     */
    private String name;

    /**
     * <p>
     * The name of the Amazon Web Services CodeCommit repository. For more information, see <a href=
     * "https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetRepository.html#CodeCommit-GetRepository-request-repositoryName"
     * >repositoryName</a> in the <i>Amazon Web Services CodeCommit API Reference</i>.
     * </p>
     * 
     * @param name
     *        The name of the Amazon Web Services CodeCommit repository. For more information, see <a href=
     *        "https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetRepository.html#CodeCommit-GetRepository-request-repositoryName"
     *        >repositoryName</a> in the <i>Amazon Web Services CodeCommit API Reference</i>.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the Amazon Web Services CodeCommit repository. For more information, see <a href=
     * "https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetRepository.html#CodeCommit-GetRepository-request-repositoryName"
     * >repositoryName</a> in the <i>Amazon Web Services CodeCommit API Reference</i>.
     * </p>
     * 
     * @return The name of the Amazon Web Services CodeCommit repository. For more information, see <a href=
     *         "https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetRepository.html#CodeCommit-GetRepository-request-repositoryName"
     *         >repositoryName</a> in the <i>Amazon Web Services CodeCommit API Reference</i>.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the Amazon Web Services CodeCommit repository. For more information, see <a href=
     * "https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetRepository.html#CodeCommit-GetRepository-request-repositoryName"
     * >repositoryName</a> in the <i>Amazon Web Services CodeCommit API Reference</i>.
     * </p>
     * 
     * @param name
     *        The name of the Amazon Web Services CodeCommit repository. For more information, see <a href=
     *        "https://docs.aws.amazon.com/codecommit/latest/APIReference/API_GetRepository.html#CodeCommit-GetRepository-request-repositoryName"
     *        >repositoryName</a> in the <i>Amazon Web Services CodeCommit API Reference</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CodeCommitRepository withName(String name) {
        setName(name);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getName() != null)
            sb.append("Name: ").append(getName());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CodeCommitRepository == false)
            return false;
        CodeCommitRepository other = (CodeCommitRepository) obj;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        return hashCode;
    }

    @Override
    public CodeCommitRepository clone() {
        try {
            return (CodeCommitRepository) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.codegurureviewer.model.transform.CodeCommitRepositoryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
