/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.codebuild.model.ScopeConfiguration;
import com.amazonaws.services.codebuild.model.WebhookBuildType;
import com.amazonaws.services.codebuild.model.WebhookFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateWebhookRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String projectName;
    private String branchFilter;
    private List<List<WebhookFilter>> filterGroups;
    private String buildType;
    private Boolean manualCreation;
    private ScopeConfiguration scopeConfiguration;

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public CreateWebhookRequest withProjectName(String projectName) {
        this.setProjectName(projectName);
        return this;
    }

    public void setBranchFilter(String branchFilter) {
        this.branchFilter = branchFilter;
    }

    public String getBranchFilter() {
        return this.branchFilter;
    }

    public CreateWebhookRequest withBranchFilter(String branchFilter) {
        this.setBranchFilter(branchFilter);
        return this;
    }

    public List<List<WebhookFilter>> getFilterGroups() {
        return this.filterGroups;
    }

    public void setFilterGroups(Collection<List<WebhookFilter>> filterGroups) {
        if (filterGroups == null) {
            this.filterGroups = null;
            return;
        }
        this.filterGroups = new ArrayList<List<WebhookFilter>>(filterGroups);
    }

    public CreateWebhookRequest withFilterGroups(List<WebhookFilter> ... filterGroups) {
        if (this.filterGroups == null) {
            this.setFilterGroups(new ArrayList<List<WebhookFilter>>(filterGroups.length));
        }
        for (List<WebhookFilter> ele : filterGroups) {
            this.filterGroups.add(ele);
        }
        return this;
    }

    public CreateWebhookRequest withFilterGroups(Collection<List<WebhookFilter>> filterGroups) {
        this.setFilterGroups(filterGroups);
        return this;
    }

    public void setBuildType(String buildType) {
        this.buildType = buildType;
    }

    public String getBuildType() {
        return this.buildType;
    }

    public CreateWebhookRequest withBuildType(String buildType) {
        this.setBuildType(buildType);
        return this;
    }

    public CreateWebhookRequest withBuildType(WebhookBuildType buildType) {
        this.buildType = buildType.toString();
        return this;
    }

    public void setManualCreation(Boolean manualCreation) {
        this.manualCreation = manualCreation;
    }

    public Boolean getManualCreation() {
        return this.manualCreation;
    }

    public CreateWebhookRequest withManualCreation(Boolean manualCreation) {
        this.setManualCreation(manualCreation);
        return this;
    }

    public Boolean isManualCreation() {
        return this.manualCreation;
    }

    public void setScopeConfiguration(ScopeConfiguration scopeConfiguration) {
        this.scopeConfiguration = scopeConfiguration;
    }

    public ScopeConfiguration getScopeConfiguration() {
        return this.scopeConfiguration;
    }

    public CreateWebhookRequest withScopeConfiguration(ScopeConfiguration scopeConfiguration) {
        this.setScopeConfiguration(scopeConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProjectName() != null) {
            sb.append("ProjectName: ").append(this.getProjectName()).append(",");
        }
        if (this.getBranchFilter() != null) {
            sb.append("BranchFilter: ").append(this.getBranchFilter()).append(",");
        }
        if (this.getFilterGroups() != null) {
            sb.append("FilterGroups: ").append(this.getFilterGroups()).append(",");
        }
        if (this.getBuildType() != null) {
            sb.append("BuildType: ").append(this.getBuildType()).append(",");
        }
        if (this.getManualCreation() != null) {
            sb.append("ManualCreation: ").append(this.getManualCreation()).append(",");
        }
        if (this.getScopeConfiguration() != null) {
            sb.append("ScopeConfiguration: ").append(this.getScopeConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWebhookRequest)) {
            return false;
        }
        CreateWebhookRequest other = (CreateWebhookRequest)obj;
        if (other.getProjectName() == null ^ this.getProjectName() == null) {
            return false;
        }
        if (other.getProjectName() != null && !other.getProjectName().equals(this.getProjectName())) {
            return false;
        }
        if (other.getBranchFilter() == null ^ this.getBranchFilter() == null) {
            return false;
        }
        if (other.getBranchFilter() != null && !other.getBranchFilter().equals(this.getBranchFilter())) {
            return false;
        }
        if (other.getFilterGroups() == null ^ this.getFilterGroups() == null) {
            return false;
        }
        if (other.getFilterGroups() != null && !other.getFilterGroups().equals(this.getFilterGroups())) {
            return false;
        }
        if (other.getBuildType() == null ^ this.getBuildType() == null) {
            return false;
        }
        if (other.getBuildType() != null && !other.getBuildType().equals(this.getBuildType())) {
            return false;
        }
        if (other.getManualCreation() == null ^ this.getManualCreation() == null) {
            return false;
        }
        if (other.getManualCreation() != null && !other.getManualCreation().equals(this.getManualCreation())) {
            return false;
        }
        if (other.getScopeConfiguration() == null ^ this.getScopeConfiguration() == null) {
            return false;
        }
        return other.getScopeConfiguration() == null || other.getScopeConfiguration().equals(this.getScopeConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProjectName() == null ? 0 : this.getProjectName().hashCode());
        hashCode = 31 * hashCode + (this.getBranchFilter() == null ? 0 : this.getBranchFilter().hashCode());
        hashCode = 31 * hashCode + (this.getFilterGroups() == null ? 0 : this.getFilterGroups().hashCode());
        hashCode = 31 * hashCode + (this.getBuildType() == null ? 0 : this.getBuildType().hashCode());
        hashCode = 31 * hashCode + (this.getManualCreation() == null ? 0 : this.getManualCreation().hashCode());
        hashCode = 31 * hashCode + (this.getScopeConfiguration() == null ? 0 : this.getScopeConfiguration().hashCode());
        return hashCode;
    }

    public CreateWebhookRequest clone() {
        return (CreateWebhookRequest)super.clone();
    }
}

