/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.codegen.emitters;

import com.amazonaws.codegen.emitters.ClassGeneratorTask;
import com.amazonaws.codegen.emitters.CodeWriter;
import com.amazonaws.codegen.internal.Freemarker;
import com.amazonaws.codegen.internal.ImmutableMapParameter;
import com.amazonaws.codegen.internal.Utils;
import com.amazonaws.codegen.model.config.customization.AuthPolicyActions;
import com.amazonaws.codegen.model.config.customization.CustomizationConfig;
import com.amazonaws.codegen.model.config.templates.CodeGenTemplatesConfig;
import com.amazonaws.codegen.model.intermediate.IntermediateModel;
import com.amazonaws.codegen.model.intermediate.Metadata;
import com.amazonaws.codegen.model.intermediate.Protocol;
import com.amazonaws.codegen.model.intermediate.ShapeModel;
import com.amazonaws.codegen.model.intermediate.ShapeType;
import com.amazonaws.codegen.model.intermediate.WaiterDefinitionModel;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import freemarker.template.Template;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class CodeEmitter
implements AutoCloseable {
    private static final boolean DEBUG = false;
    protected final IntermediateModel model;
    private final ExecutorService executors = Executors.newFixedThreadPool(10);
    private final List<Future<Void>> futures = new ArrayList<Future<Void>>();
    private final String baseDirectory;
    private final String modelClassDir;
    private final String transformClassDir;
    private final String policyEnumClassDir;
    private final String smokeTestsPackageDir;
    private final String waiterClassDir;
    protected final Freemarker freemarker;

    public CodeEmitter(IntermediateModel model, String outputDirectory) {
        if (model == null) {
            throw new IllegalArgumentException("Intermediate Model cannot be null");
        }
        if (outputDirectory == null || outputDirectory.trim().isEmpty()) {
            throw new IllegalArgumentException("Invalid output directory path");
        }
        this.model = model;
        this.baseDirectory = outputDirectory + "/" + model.getMetadata().getPackagePath();
        this.modelClassDir = this.baseDirectory + "/" + "model";
        this.transformClassDir = this.modelClassDir + "/" + "transform";
        this.policyEnumClassDir = outputDirectory + "/" + "com/amazonaws/auth/policy/actions";
        this.waiterClassDir = this.baseDirectory + "/" + "waiters";
        this.freemarker = new Freemarker(this.loadProtocolTemplatesConfig(model.getMetadata().getProtocol()));
        this.smokeTestsPackageDir = outputDirectory + "/../" + "smoketests" + "/" + model.getMetadata().getPackagePath() + "/" + "smoketests";
    }

    public void emit() throws JsonGenerationException, JsonMappingException, IOException, InterruptedException, ExecutionException {
        Utils.createDirectory(this.transformClassDir);
        Utils.createDirectory(this.waiterClassDir);
        Utils.createDirectory(this.smokeTestsPackageDir);
        this.emitWaiterOpFunctionClasses();
        this.emitWaiterAcceptorClasses();
        this.emitWaiterClasses();
        this.emitClientInterfaces();
        this.emitClientClasses();
        this.emitClientBuilders();
        this.emitModelClasses();
        if (this.model.getCustomizationConfig().getSdkModeledExceptionBaseClassName() == null) {
            this.emitExceptionBaseClass();
        }
        this.emitMarshallerClasses();
        this.emitUnmarshallerClasses();
        this.emitPolicyActionEnumClass();
        this.emitPackageInfoFile();
        if (!this.model.getCustomizationConfig().isSkipSmokeTests()) {
            this.emitSmokeTestFiles();
        }
        this.waitForCompletion();
    }

    @Override
    public void close() {
        this.executors.shutdown();
    }

    private void emitPackageInfoFile() throws IOException {
        this.submitTask(new ClassGeneratorTask(this.baseDirectory, "package-info.java", this.freemarker.getPackageInfoTemplate(), this.model));
    }

    private void emitSmokeTestFiles() throws IOException {
        this.submitTask(new ClassGeneratorTask(this.smokeTestsPackageDir, this.model.getMetadata().getCucumberModuleInjectorClassName(), this.freemarker.getCucumberModuleInjectorTemplate(), this.model));
        this.submitTask(new ClassGeneratorTask(this.smokeTestsPackageDir, "RunCucumberTest", this.freemarker.getCucumberTestTemplate(), this.model));
        this.submitTask(new ClassGeneratorTask(new CodeWriter(this.smokeTestsPackageDir, "cucumber", ".properties"), this.freemarker.getCucumberPropertiesTemplate(), this.model));
    }

    protected void emitClientClasses() throws IOException {
        this.submitTask(new ClassGeneratorTask(this.baseDirectory, this.model.getMetadata().getSyncAbstractClass(), this.freemarker.getSyncAbstractClassTemplate(), this.model));
        this.submitTask(new ClassGeneratorTask(this.baseDirectory, this.model.getMetadata().getSyncClient(), this.freemarker.getSyncClientTemplate(), this.model));
        if (this.model.getMetadata().hasAsyncClient()) {
            this.submitTask(new ClassGeneratorTask(this.baseDirectory, this.model.getMetadata().getAsyncAbstractClass(), this.freemarker.getAsyncAbstractClassTemplate(), this.model));
            this.submitTask(new ClassGeneratorTask(this.baseDirectory, this.model.getMetadata().getAsyncClient(), this.freemarker.getAsyncClientTemplate(), this.model));
        }
    }

    protected void emitClientBuilders() throws IOException {
        this.submitTask(new ClassGeneratorTask(this.baseDirectory, this.model.getMetadata().getSyncClientBuilderClassName(), this.freemarker.getSyncClientBuilderTemplate(), this.model));
        if (this.model.getMetadata().hasAsyncClient()) {
            this.submitTask(new ClassGeneratorTask(this.baseDirectory, this.model.getMetadata().getAsyncClientBuilderClassName(), this.freemarker.getAsyncClientBuilderTemplate(), this.model));
        }
    }

    private void submitTask(ClassGeneratorTask task) {
        this.futures.add(this.executors.submit(task));
    }

    protected void emitClientInterfaces() throws IOException {
        this.submitTask(new ClassGeneratorTask(this.baseDirectory, this.model.getMetadata().getSyncInterface(), this.freemarker.getSyncInterfaceTemplate(), this.model));
        if (this.model.getMetadata().hasAsyncClient()) {
            this.submitTask(new ClassGeneratorTask(this.baseDirectory, this.model.getMetadata().getAsyncInterface(), this.freemarker.getAsyncInterfaceTemplate(), this.model));
        }
    }

    protected void emitModelClasses() throws IOException {
        Metadata metadata = this.model.getMetadata();
        Map<String, ShapeModel> shapes = this.model.getShapes();
        for (Map.Entry<String, ShapeModel> entry : shapes.entrySet()) {
            String javaShapeName = entry.getKey();
            ShapeModel shapeModel = entry.getValue();
            if (shapeModel.getCustomization().isSkipGeneratingModelClass()) {
                System.out.println("Skip generating class " + shapeModel.getShapeName());
                continue;
            }
            ImmutableMapParameter<String, String> dataModel = ImmutableMapParameter.builder().put("fileHeader", this.model.getFileHeader()).put("shape", (String)((Object)shapeModel)).put("metadata", (String)((Object)metadata)).put("baseClassFqcn", this.getModelBaseClassFqcn(shapeModel.getType())).put("customConfig", (String)((Object)this.model.getCustomizationConfig())).build();
            this.submitTask(new ClassGeneratorTask(this.modelClassDir, javaShapeName, this.freemarker.getShapeTemplate(shapeModel), dataModel));
        }
    }

    private String getModelBaseClassFqcn(String shapeType) {
        switch (ShapeType.fromValue(shapeType)) {
            case Exception: {
                return this.model.getSdkModeledExceptionBaseFqcn();
            }
            case Response: {
                return this.model.getSdkBaseResponseFqcn();
            }
            case Request: {
                return "com.amazonaws.AmazonWebServiceRequest";
            }
        }
        return null;
    }

    private void emitExceptionBaseClass() throws IOException {
        String baseClassName = this.model.getSdkModeledExceptionBaseClassName();
        this.submitTask(new ClassGeneratorTask(this.modelClassDir, baseClassName, this.freemarker.getBaseExceptionClassTemplate(), ImmutableMapParameter.of("fileHeader", this.model.getFileHeader(), "className", baseClassName, "metadata", this.model.getMetadata(), "baseExceptionFqcn", this.model.getServiceBaseExceptionFqcn())));
    }

    protected void emitMarshallerClasses() throws IOException {
        Metadata metadata = this.model.getMetadata();
        Map<String, ShapeModel> shapes = this.model.getShapes();
        Template template = this.freemarker.getModelMarshallerTemplate();
        for (Map.Entry<String, ShapeModel> entry : shapes.entrySet()) {
            String className;
            String javaShapeName = entry.getKey();
            ShapeModel shapeModel = entry.getValue();
            ShapeType shapeType = ShapeType.fromValue(shapeModel.getType());
            if (shapeModel.getCustomization().isSkipGeneratingMarshaller()) {
                System.out.println("Skip generating marshaller class for " + shapeModel.getShapeName());
                continue;
            }
            ImmutableMapParameter<String, CustomizationConfig> marshallerDataModel = ImmutableMapParameter.of("fileHeader", this.model.getFileHeader(), "shapeName", javaShapeName, "shapes", shapes, "metadata", metadata, "customConfig", this.model.getCustomizationConfig());
            if (ShapeType.Request == shapeType) {
                className = this.getMarshallerClassName(shapeType, javaShapeName, metadata);
                this.submitTask(new ClassGeneratorTask(this.transformClassDir, className, template, marshallerDataModel));
                continue;
            }
            if (ShapeType.Model != shapeType || !metadata.isJsonProtocol()) continue;
            className = this.getMarshallerClassName(shapeType, javaShapeName, metadata);
            this.submitTask(new ClassGeneratorTask(this.transformClassDir, className, template, marshallerDataModel));
        }
    }

    protected String getMarshallerClassName(ShapeType shapeType, String shapeName, Metadata metadata) {
        if (ShapeType.Request == shapeType) {
            return shapeName + "Marshaller";
        }
        if (ShapeType.Model == shapeType && metadata.isJsonProtocol()) {
            return shapeName + "JsonMarshaller";
        }
        throw new IllegalArgumentException("Not able generate marshaller class name for " + shapeName + " type " + shapeType.getValue());
    }

    protected void emitUnmarshallerClasses() throws IOException {
        Metadata metadata = this.model.getMetadata();
        Template template = this.freemarker.getModelUnmarshallerTemplate();
        Map<String, ShapeModel> shapes = this.model.getShapes();
        block4: for (Map.Entry<String, ShapeModel> entry : shapes.entrySet()) {
            String javaShapeName = entry.getKey();
            ShapeModel shapeModel = entry.getValue();
            ShapeType shapeType = ShapeType.fromValue(shapeModel.getType());
            if (shapeModel.getCustomization().isSkipGeneratingUnmarshaller()) {
                System.out.println("Skip generating unmarshaller class for " + shapeModel.getShapeName());
                continue;
            }
            ImmutableMapParameter<String, String> dataModel = ImmutableMapParameter.of("fileHeader", this.model.getFileHeader(), "shape", shapeModel, "metadata", metadata, "exceptionUnmarshallerImpl", this.model.getExceptionUnmarshallerImpl());
            switch (shapeType) {
                case Response: 
                case Model: {
                    String unmarshallerNameSuffix = metadata.isJsonProtocol() ? "JsonUnmarshaller" : "StaxUnmarshaller";
                    this.submitTask(new ClassGeneratorTask(this.transformClassDir, javaShapeName + unmarshallerNameSuffix, template, dataModel));
                    continue block4;
                }
                case Exception: {
                    if (metadata.isJsonProtocol()) continue block4;
                    this.submitTask(new ClassGeneratorTask(this.transformClassDir, javaShapeName + "Unmarshaller", this.freemarker.getExceptionUnmarshallerTemplate(), dataModel));
                    continue block4;
                }
            }
        }
    }

    private void waitForCompletion() throws InterruptedException, ExecutionException {
        Exception firstEx = null;
        for (Future<Void> future : this.futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                if (firstEx != null) continue;
                firstEx = e;
            }
        }
        if (firstEx instanceof ExecutionException) {
            throw (ExecutionException)firstEx;
        }
        if (firstEx instanceof InterruptedException) {
            throw (InterruptedException)firstEx;
        }
        if (firstEx instanceof RuntimeException) {
            throw (RuntimeException)firstEx;
        }
    }

    private CodeGenTemplatesConfig loadProtocolTemplatesConfig(Protocol protocol) {
        Protocol templateProtocol = protocol;
        if (Protocol.CBOR.equals((Object)protocol) || Protocol.ION.equals((Object)protocol)) {
            templateProtocol = Protocol.JSON;
        }
        CodeGenTemplatesConfig protocolDefaultConfig = CodeGenTemplatesConfig.load(templateProtocol);
        CustomizationConfig customConfig = this.model.getCustomizationConfig();
        if (customConfig == null || customConfig.getCustomCodeTemplates() == null) {
            return protocolDefaultConfig;
        }
        return CodeGenTemplatesConfig.merge(protocolDefaultConfig, customConfig.getCustomCodeTemplates());
    }

    private void emitPolicyActionEnumClass() throws IOException {
        AuthPolicyActions policyActions = this.model.getCustomizationConfig().getAuthPolicyActions();
        if (policyActions != null && policyActions.isSkip()) {
            return;
        }
        Utils.createDirectory(this.policyEnumClassDir);
        String serviceName = this.getPolicyActionServiceName(this.model.getMetadata(), policyActions);
        String actionPrefix = this.getEnumActionPrefix(this.model.getMetadata(), policyActions);
        ImmutableMapParameter<String, String> dataModel = ImmutableMapParameter.of("fileHeader", this.model.getFileHeader(), "operations", this.model.getOperations().keySet(), "metadata", this.model.getMetadata(), "serviceName", serviceName, "actionPrefix", actionPrefix);
        this.submitTask(new ClassGeneratorTask(new CodeWriter(this.policyEnumClassDir, serviceName + "Actions"), this.freemarker.getPolicyActionClassTemplate(), dataModel));
    }

    private void emitWaiterOpFunctionClasses() throws IOException {
        ArrayList<String> generatedOperations = new ArrayList<String>();
        for (Map.Entry<String, WaiterDefinitionModel> entry : this.model.getWaiters().entrySet()) {
            WaiterDefinitionModel waiterModel = entry.getValue();
            if (generatedOperations.contains(waiterModel.getOperationName())) continue;
            generatedOperations.add(waiterModel.getOperationName());
            ImmutableMapParameter<String, Metadata> dataModel = ImmutableMapParameter.of("fileHeader", this.model.getFileHeader(), "waiter", waiterModel, "operation", this.model.getOperation(waiterModel.getOperationName()), "metadata", this.model.getMetadata());
            String className = waiterModel.getOperationModel().getOperationName() + "Function";
            this.submitTask(new ClassGeneratorTask(this.waiterClassDir, className, this.freemarker.getWaiterSDKFunctionTemplate(), dataModel));
        }
    }

    private void emitWaiterAcceptorClasses() throws IOException {
        for (Map.Entry<String, WaiterDefinitionModel> entry : this.model.getWaiters().entrySet()) {
            if (CodeEmitter.containsAllStatusMatchers(entry)) continue;
            String waiterName = entry.getKey();
            WaiterDefinitionModel waiterModel = entry.getValue();
            ImmutableMapParameter<String, Metadata> dataModel = ImmutableMapParameter.of("fileHeader", this.model.getFileHeader(), "waiter", waiterModel, "operation", this.model.getOperation(waiterModel.getOperationName()), "metadata", this.model.getMetadata());
            this.submitTask(new ClassGeneratorTask(this.waiterClassDir, waiterName, this.freemarker.getWaiterAcceptorTemplate(), dataModel));
        }
    }

    private static boolean containsAllStatusMatchers(Map.Entry<String, WaiterDefinitionModel> entry) {
        return entry.getValue().getAcceptors().stream().allMatch(a -> a.getMatcher().equals("status"));
    }

    private void emitWaiterClasses() throws IOException {
        if (this.model.getWaiters().size() > 0) {
            Metadata metadata = this.model.getMetadata();
            String className = metadata.getSyncInterface() + "Waiters";
            ImmutableMapParameter<String, Metadata> dataModel = ImmutableMapParameter.of("fileHeader", this.model.getFileHeader(), "className", className, "waiters", this.model.getWaiters(), "operation", this.model.getOperations(), "metadata", metadata);
            this.submitTask(new ClassGeneratorTask(this.waiterClassDir, className, this.freemarker.getWaiterTemplate(), dataModel));
        }
    }

    private String getPolicyActionServiceName(Metadata metadata, AuthPolicyActions policyActions) {
        if (policyActions != null && policyActions.getFileNamePrefix() != null) {
            return Utils.capitialize(policyActions.getFileNamePrefix());
        }
        return Utils.capitialize(metadata.getEndpointPrefix());
    }

    private String getEnumActionPrefix(Metadata metadata, AuthPolicyActions policyActions) {
        if (policyActions != null && policyActions.getActionPrefix() != null) {
            return policyActions.getActionPrefix();
        }
        return metadata.getEndpointPrefix();
    }
}

