/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.services.cloudwatch.model.Entity;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.transform.rpcv2cbor.MapUnmarshaller;
import com.amazonaws.transform.rpcv2cbor.RpcV2CborUnmarshallerContext;
import com.fasterxml.jackson.core.JsonToken;

public class EntityRpcV2CborUnmarshaller
implements Unmarshaller<Entity, RpcV2CborUnmarshallerContext> {
    private static EntityRpcV2CborUnmarshaller instance;

    public Entity unmarshall(RpcV2CborUnmarshallerContext context) throws Exception {
        Entity entity = new Entity();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("KeyAttributes", targetDepth)) {
                    context.nextToken();
                    entity.setKeyAttributes(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("Attributes", targetDepth)) {
                    context.nextToken();
                    entity.setAttributes(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return entity;
    }

    public static EntityRpcV2CborUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EntityRpcV2CborUnmarshaller();
        }
        return instance;
    }
}

