/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudwatch.model.AnomalyDetector;
import java.util.List;

@SdkInternalApi
public class AnomalyDetectorMarshaller {
    private static final MarshallingInfo<String> NAMESPACE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Namespace").build();
    private static final MarshallingInfo<String> METRICNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetricName").build();
    private static final MarshallingInfo<List> DIMENSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Dimensions").build();
    private static final MarshallingInfo<String> STAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Stat").build();
    private static final MarshallingInfo<StructuredPojo> CONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Configuration").build();
    private static final MarshallingInfo<String> STATEVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateValue").build();
    private static final MarshallingInfo<StructuredPojo> METRICCHARACTERISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetricCharacteristics").build();
    private static final MarshallingInfo<StructuredPojo> SINGLEMETRICANOMALYDETECTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SingleMetricAnomalyDetector").build();
    private static final MarshallingInfo<StructuredPojo> METRICMATHANOMALYDETECTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MetricMathAnomalyDetector").build();
    private static final AnomalyDetectorMarshaller instance = new AnomalyDetectorMarshaller();

    public static AnomalyDetectorMarshaller getInstance() {
        return instance;
    }

    public void marshall(AnomalyDetector anomalyDetector, ProtocolMarshaller protocolMarshaller) {
        if (anomalyDetector == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)anomalyDetector.getNamespace(), NAMESPACE_BINDING);
            protocolMarshaller.marshall((Object)anomalyDetector.getMetricName(), METRICNAME_BINDING);
            if (anomalyDetector.getDimensions() != null && !anomalyDetector.getDimensions().isEmpty()) {
                protocolMarshaller.marshall(anomalyDetector.getDimensions(), DIMENSIONS_BINDING);
            }
            protocolMarshaller.marshall((Object)anomalyDetector.getStat(), STAT_BINDING);
            protocolMarshaller.marshall((Object)anomalyDetector.getConfiguration(), CONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)anomalyDetector.getStateValue(), STATEVALUE_BINDING);
            protocolMarshaller.marshall((Object)anomalyDetector.getMetricCharacteristics(), METRICCHARACTERISTICS_BINDING);
            protocolMarshaller.marshall((Object)anomalyDetector.getSingleMetricAnomalyDetector(), SINGLEMETRICANOMALYDETECTOR_BINDING);
            protocolMarshaller.marshall((Object)anomalyDetector.getMetricMathAnomalyDetector(), METRICMATHANOMALYDETECTOR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request: " + e.getMessage(), (Throwable)e);
        }
    }
}

