/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.ManagedRule;
import com.amazonaws.services.cloudwatch.model.PutManagedInsightRulesRequest;
import com.amazonaws.services.cloudwatch.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class PutManagedInsightRulesRequestMarshaller
implements Marshaller<Request<PutManagedInsightRulesRequest>, PutManagedInsightRulesRequest> {
    public Request<PutManagedInsightRulesRequest> marshall(PutManagedInsightRulesRequest putManagedInsightRulesRequest) {
        if (putManagedInsightRulesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putManagedInsightRulesRequest, "AmazonCloudWatch");
        request.addParameter("Action", "PutManagedInsightRules");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (!putManagedInsightRulesRequest.getManagedRules().isEmpty() || !((SdkInternalList)putManagedInsightRulesRequest.getManagedRules()).isAutoConstruct()) {
            SdkInternalList managedRulesList = (SdkInternalList)putManagedInsightRulesRequest.getManagedRules();
            int managedRulesListIndex = 1;
            for (ManagedRule managedRulesListValue : managedRulesList) {
                if (managedRulesListValue != null) {
                    if (managedRulesListValue.getTemplateName() != null) {
                        request.addParameter("ManagedRules.member." + managedRulesListIndex + ".TemplateName", StringUtils.fromString((String)managedRulesListValue.getTemplateName()));
                    }
                    if (managedRulesListValue.getResourceARN() != null) {
                        request.addParameter("ManagedRules.member." + managedRulesListIndex + ".ResourceARN", StringUtils.fromString((String)managedRulesListValue.getResourceARN()));
                    }
                    if (!managedRulesListValue.getTags().isEmpty() || !((SdkInternalList)managedRulesListValue.getTags()).isAutoConstruct()) {
                        SdkInternalList tagsList = (SdkInternalList)managedRulesListValue.getTags();
                        int tagsListIndex = 1;
                        for (Tag tagsListValue : tagsList) {
                            if (tagsListValue != null) {
                                if (tagsListValue.getKey() != null) {
                                    request.addParameter("ManagedRules.member." + managedRulesListIndex + ".Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                                }
                                if (tagsListValue.getValue() != null) {
                                    request.addParameter("ManagedRules.member." + managedRulesListIndex + ".Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                                }
                            }
                            ++tagsListIndex;
                        }
                    }
                }
                ++managedRulesListIndex;
            }
        }
        return request;
    }
}

