/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cloudwatch.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * <p>
 * This structure is used in both <code>GetMetricData</code> and <code>PutMetricAlarm</code>. The supported use of this
 * structure is different for those two operations.
 * </p>
 * <p>
 * When used in <code>GetMetricData</code>, it indicates the metric data to return, and whether this call is just
 * retrieving a batch set of data for one metric, or is performing a Metrics Insights query or a math expression. A
 * single <code>GetMetricData</code> call can include up to 500 <code>MetricDataQuery</code> structures.
 * </p>
 * <p>
 * When used in <code>PutMetricAlarm</code>, it enables you to create an alarm based on a metric math expression. Each
 * <code>MetricDataQuery</code> in the array specifies either a metric to retrieve, or a math expression to be performed
 * on retrieved metrics. A single <code>PutMetricAlarm</code> call can include up to 20 <code>MetricDataQuery</code>
 * structures in the array. The 20 structures can include as many as 10 structures that contain a
 * <code>MetricStat</code> parameter to retrieve a metric, and as many as 10 structures that contain the
 * <code>Expression</code> parameter to perform a math expression. Of those <code>Expression</code> structures, one must
 * have <code>true</code> as the value for <code>ReturnData</code>. The result of this expression is the value the alarm
 * watches.
 * </p>
 * <p>
 * Any expression used in a <code>PutMetricAlarm</code> operation must return a single time series. For more
 * information, see <a
 * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax"
 * >Metric Math Syntax and Functions</a> in the <i>Amazon CloudWatch User Guide</i>.
 * </p>
 * <p>
 * Some of the parameters of this structure also have different uses whether you are using this structure in a
 * <code>GetMetricData</code> operation or a <code>PutMetricAlarm</code> operation. These differences are explained in
 * the following parameter list.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/monitoring-2010-08-01/MetricDataQuery" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class MetricDataQuery implements Serializable, Cloneable {

    /**
     * <p>
     * A short name used to tie this object to the results in the response. This name must be unique within a single
     * call to <code>GetMetricData</code>. If you are performing math expressions on this set of data, this name
     * represents that data and can serve as a variable in the mathematical expression. The valid characters are
     * letters, numbers, and underscore. The first character must be a lowercase letter.
     * </p>
     */
    private String id;
    /**
     * <p>
     * The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is
     * retrieving a metric and not performing a math expression on returned data.
     * </p>
     * <p>
     * Within one MetricDataQuery object, you must specify either <code>Expression</code> or <code>MetricStat</code> but
     * not both.
     * </p>
     */
    private MetricStat metricStat;
    /**
     * <p>
     * This field can contain either a Metrics Insights query, or a metric math expression to be performed on the
     * returned data. For more information about Metrics Insights queries, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch-metrics-insights-querylanguage"
     * >Metrics Insights query components and syntax</a> in the <i>Amazon CloudWatch User Guide</i>.
     * </p>
     * <p>
     * A math expression can use the <code>Id</code> of the other metrics or queries to refer to those metrics, and can
     * also use the <code>Id</code> of other expressions to use the result of those expressions. For more information
     * about metric math expressions, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax"
     * >Metric Math Syntax and Functions</a> in the <i>Amazon CloudWatch User Guide</i>.
     * </p>
     * <p>
     * Within each MetricDataQuery object, you must specify either <code>Expression</code> or <code>MetricStat</code>
     * but not both.
     * </p>
     */
    private String expression;
    /**
     * <p>
     * A human-readable label for this metric or expression. This is especially useful if this is an expression, so that
     * you know what the value represents. If the metric or expression is shown in a CloudWatch dashboard widget, the
     * label is shown. If Label is omitted, CloudWatch generates a default.
     * </p>
     * <p>
     * You can put dynamic expressions into a label, so that it is more descriptive. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">Using Dynamic
     * Labels</a>.
     * </p>
     */
    private String label;
    /**
     * <p>
     * When used in <code>GetMetricData</code>, this option indicates whether to return the timestamps and raw data
     * values of this metric. If you are performing this call just to do math expressions and do not also need the raw
     * data returned, you can specify <code>false</code>. If you omit this, the default of <code>true</code> is used.
     * </p>
     * <p>
     * When used in <code>PutMetricAlarm</code>, specify <code>true</code> for the one expression result to use as the
     * alarm. For all other metrics and expressions in the same <code>PutMetricAlarm</code> operation, specify
     * <code>ReturnData</code> as False.
     * </p>
     */
    private Boolean returnData;
    /**
     * <p>
     * The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can be as
     * short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at
     * intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution
     * metrics are those metrics stored by a <code>PutMetricData</code> operation that includes a
     * <code>StorageResolution of 1 second</code>.
     * </p>
     */
    private Integer period;
    /**
     * <p>
     * The ID of the account where the metrics are located.
     * </p>
     * <p>
     * If you are performing a <code>GetMetricData</code> operation in a monitoring account, use this to specify which
     * account to retrieve this metric from.
     * </p>
     * <p>
     * If you are performing a <code>PutMetricAlarm</code> operation, use this to specify which account contains the
     * metric that the alarm is watching.
     * </p>
     */
    private String accountId;

    /**
     * <p>
     * A short name used to tie this object to the results in the response. This name must be unique within a single
     * call to <code>GetMetricData</code>. If you are performing math expressions on this set of data, this name
     * represents that data and can serve as a variable in the mathematical expression. The valid characters are
     * letters, numbers, and underscore. The first character must be a lowercase letter.
     * </p>
     * 
     * @param id
     *        A short name used to tie this object to the results in the response. This name must be unique within a
     *        single call to <code>GetMetricData</code>. If you are performing math expressions on this set of data,
     *        this name represents that data and can serve as a variable in the mathematical expression. The valid
     *        characters are letters, numbers, and underscore. The first character must be a lowercase letter.
     */

    public void setId(String id) {
        this.id = id;
    }

    /**
     * <p>
     * A short name used to tie this object to the results in the response. This name must be unique within a single
     * call to <code>GetMetricData</code>. If you are performing math expressions on this set of data, this name
     * represents that data and can serve as a variable in the mathematical expression. The valid characters are
     * letters, numbers, and underscore. The first character must be a lowercase letter.
     * </p>
     * 
     * @return A short name used to tie this object to the results in the response. This name must be unique within a
     *         single call to <code>GetMetricData</code>. If you are performing math expressions on this set of data,
     *         this name represents that data and can serve as a variable in the mathematical expression. The valid
     *         characters are letters, numbers, and underscore. The first character must be a lowercase letter.
     */

    public String getId() {
        return this.id;
    }

    /**
     * <p>
     * A short name used to tie this object to the results in the response. This name must be unique within a single
     * call to <code>GetMetricData</code>. If you are performing math expressions on this set of data, this name
     * represents that data and can serve as a variable in the mathematical expression. The valid characters are
     * letters, numbers, and underscore. The first character must be a lowercase letter.
     * </p>
     * 
     * @param id
     *        A short name used to tie this object to the results in the response. This name must be unique within a
     *        single call to <code>GetMetricData</code>. If you are performing math expressions on this set of data,
     *        this name represents that data and can serve as a variable in the mathematical expression. The valid
     *        characters are letters, numbers, and underscore. The first character must be a lowercase letter.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MetricDataQuery withId(String id) {
        setId(id);
        return this;
    }

    /**
     * <p>
     * The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is
     * retrieving a metric and not performing a math expression on returned data.
     * </p>
     * <p>
     * Within one MetricDataQuery object, you must specify either <code>Expression</code> or <code>MetricStat</code> but
     * not both.
     * </p>
     * 
     * @param metricStat
     *        The metric to be returned, along with statistics, period, and units. Use this parameter only if this
     *        object is retrieving a metric and not performing a math expression on returned data.</p>
     *        <p>
     *        Within one MetricDataQuery object, you must specify either <code>Expression</code> or
     *        <code>MetricStat</code> but not both.
     */

    public void setMetricStat(MetricStat metricStat) {
        this.metricStat = metricStat;
    }

    /**
     * <p>
     * The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is
     * retrieving a metric and not performing a math expression on returned data.
     * </p>
     * <p>
     * Within one MetricDataQuery object, you must specify either <code>Expression</code> or <code>MetricStat</code> but
     * not both.
     * </p>
     * 
     * @return The metric to be returned, along with statistics, period, and units. Use this parameter only if this
     *         object is retrieving a metric and not performing a math expression on returned data.</p>
     *         <p>
     *         Within one MetricDataQuery object, you must specify either <code>Expression</code> or
     *         <code>MetricStat</code> but not both.
     */

    public MetricStat getMetricStat() {
        return this.metricStat;
    }

    /**
     * <p>
     * The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is
     * retrieving a metric and not performing a math expression on returned data.
     * </p>
     * <p>
     * Within one MetricDataQuery object, you must specify either <code>Expression</code> or <code>MetricStat</code> but
     * not both.
     * </p>
     * 
     * @param metricStat
     *        The metric to be returned, along with statistics, period, and units. Use this parameter only if this
     *        object is retrieving a metric and not performing a math expression on returned data.</p>
     *        <p>
     *        Within one MetricDataQuery object, you must specify either <code>Expression</code> or
     *        <code>MetricStat</code> but not both.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MetricDataQuery withMetricStat(MetricStat metricStat) {
        setMetricStat(metricStat);
        return this;
    }

    /**
     * <p>
     * This field can contain either a Metrics Insights query, or a metric math expression to be performed on the
     * returned data. For more information about Metrics Insights queries, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch-metrics-insights-querylanguage"
     * >Metrics Insights query components and syntax</a> in the <i>Amazon CloudWatch User Guide</i>.
     * </p>
     * <p>
     * A math expression can use the <code>Id</code> of the other metrics or queries to refer to those metrics, and can
     * also use the <code>Id</code> of other expressions to use the result of those expressions. For more information
     * about metric math expressions, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax"
     * >Metric Math Syntax and Functions</a> in the <i>Amazon CloudWatch User Guide</i>.
     * </p>
     * <p>
     * Within each MetricDataQuery object, you must specify either <code>Expression</code> or <code>MetricStat</code>
     * but not both.
     * </p>
     * 
     * @param expression
     *        This field can contain either a Metrics Insights query, or a metric math expression to be performed on the
     *        returned data. For more information about Metrics Insights queries, see <a href=
     *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch-metrics-insights-querylanguage"
     *        >Metrics Insights query components and syntax</a> in the <i>Amazon CloudWatch User Guide</i>.</p>
     *        <p>
     *        A math expression can use the <code>Id</code> of the other metrics or queries to refer to those metrics,
     *        and can also use the <code>Id</code> of other expressions to use the result of those expressions. For more
     *        information about metric math expressions, see <a href=
     *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax"
     *        >Metric Math Syntax and Functions</a> in the <i>Amazon CloudWatch User Guide</i>.
     *        </p>
     *        <p>
     *        Within each MetricDataQuery object, you must specify either <code>Expression</code> or
     *        <code>MetricStat</code> but not both.
     */

    public void setExpression(String expression) {
        this.expression = expression;
    }

    /**
     * <p>
     * This field can contain either a Metrics Insights query, or a metric math expression to be performed on the
     * returned data. For more information about Metrics Insights queries, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch-metrics-insights-querylanguage"
     * >Metrics Insights query components and syntax</a> in the <i>Amazon CloudWatch User Guide</i>.
     * </p>
     * <p>
     * A math expression can use the <code>Id</code> of the other metrics or queries to refer to those metrics, and can
     * also use the <code>Id</code> of other expressions to use the result of those expressions. For more information
     * about metric math expressions, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax"
     * >Metric Math Syntax and Functions</a> in the <i>Amazon CloudWatch User Guide</i>.
     * </p>
     * <p>
     * Within each MetricDataQuery object, you must specify either <code>Expression</code> or <code>MetricStat</code>
     * but not both.
     * </p>
     * 
     * @return This field can contain either a Metrics Insights query, or a metric math expression to be performed on
     *         the returned data. For more information about Metrics Insights queries, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch-metrics-insights-querylanguage"
     *         >Metrics Insights query components and syntax</a> in the <i>Amazon CloudWatch User Guide</i>.</p>
     *         <p>
     *         A math expression can use the <code>Id</code> of the other metrics or queries to refer to those metrics,
     *         and can also use the <code>Id</code> of other expressions to use the result of those expressions. For
     *         more information about metric math expressions, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax"
     *         >Metric Math Syntax and Functions</a> in the <i>Amazon CloudWatch User Guide</i>.
     *         </p>
     *         <p>
     *         Within each MetricDataQuery object, you must specify either <code>Expression</code> or
     *         <code>MetricStat</code> but not both.
     */

    public String getExpression() {
        return this.expression;
    }

    /**
     * <p>
     * This field can contain either a Metrics Insights query, or a metric math expression to be performed on the
     * returned data. For more information about Metrics Insights queries, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch-metrics-insights-querylanguage"
     * >Metrics Insights query components and syntax</a> in the <i>Amazon CloudWatch User Guide</i>.
     * </p>
     * <p>
     * A math expression can use the <code>Id</code> of the other metrics or queries to refer to those metrics, and can
     * also use the <code>Id</code> of other expressions to use the result of those expressions. For more information
     * about metric math expressions, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax"
     * >Metric Math Syntax and Functions</a> in the <i>Amazon CloudWatch User Guide</i>.
     * </p>
     * <p>
     * Within each MetricDataQuery object, you must specify either <code>Expression</code> or <code>MetricStat</code>
     * but not both.
     * </p>
     * 
     * @param expression
     *        This field can contain either a Metrics Insights query, or a metric math expression to be performed on the
     *        returned data. For more information about Metrics Insights queries, see <a href=
     *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch-metrics-insights-querylanguage"
     *        >Metrics Insights query components and syntax</a> in the <i>Amazon CloudWatch User Guide</i>.</p>
     *        <p>
     *        A math expression can use the <code>Id</code> of the other metrics or queries to refer to those metrics,
     *        and can also use the <code>Id</code> of other expressions to use the result of those expressions. For more
     *        information about metric math expressions, see <a href=
     *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax"
     *        >Metric Math Syntax and Functions</a> in the <i>Amazon CloudWatch User Guide</i>.
     *        </p>
     *        <p>
     *        Within each MetricDataQuery object, you must specify either <code>Expression</code> or
     *        <code>MetricStat</code> but not both.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MetricDataQuery withExpression(String expression) {
        setExpression(expression);
        return this;
    }

    /**
     * <p>
     * A human-readable label for this metric or expression. This is especially useful if this is an expression, so that
     * you know what the value represents. If the metric or expression is shown in a CloudWatch dashboard widget, the
     * label is shown. If Label is omitted, CloudWatch generates a default.
     * </p>
     * <p>
     * You can put dynamic expressions into a label, so that it is more descriptive. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">Using Dynamic
     * Labels</a>.
     * </p>
     * 
     * @param label
     *        A human-readable label for this metric or expression. This is especially useful if this is an expression,
     *        so that you know what the value represents. If the metric or expression is shown in a CloudWatch dashboard
     *        widget, the label is shown. If Label is omitted, CloudWatch generates a default.</p>
     *        <p>
     *        You can put dynamic expressions into a label, so that it is more descriptive. For more information, see <a
     *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">Using
     *        Dynamic Labels</a>.
     */

    public void setLabel(String label) {
        this.label = label;
    }

    /**
     * <p>
     * A human-readable label for this metric or expression. This is especially useful if this is an expression, so that
     * you know what the value represents. If the metric or expression is shown in a CloudWatch dashboard widget, the
     * label is shown. If Label is omitted, CloudWatch generates a default.
     * </p>
     * <p>
     * You can put dynamic expressions into a label, so that it is more descriptive. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">Using Dynamic
     * Labels</a>.
     * </p>
     * 
     * @return A human-readable label for this metric or expression. This is especially useful if this is an expression,
     *         so that you know what the value represents. If the metric or expression is shown in a CloudWatch
     *         dashboard widget, the label is shown. If Label is omitted, CloudWatch generates a default.</p>
     *         <p>
     *         You can put dynamic expressions into a label, so that it is more descriptive. For more information, see
     *         <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">Using
     *         Dynamic Labels</a>.
     */

    public String getLabel() {
        return this.label;
    }

    /**
     * <p>
     * A human-readable label for this metric or expression. This is especially useful if this is an expression, so that
     * you know what the value represents. If the metric or expression is shown in a CloudWatch dashboard widget, the
     * label is shown. If Label is omitted, CloudWatch generates a default.
     * </p>
     * <p>
     * You can put dynamic expressions into a label, so that it is more descriptive. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">Using Dynamic
     * Labels</a>.
     * </p>
     * 
     * @param label
     *        A human-readable label for this metric or expression. This is especially useful if this is an expression,
     *        so that you know what the value represents. If the metric or expression is shown in a CloudWatch dashboard
     *        widget, the label is shown. If Label is omitted, CloudWatch generates a default.</p>
     *        <p>
     *        You can put dynamic expressions into a label, so that it is more descriptive. For more information, see <a
     *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/graph-dynamic-labels.html">Using
     *        Dynamic Labels</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MetricDataQuery withLabel(String label) {
        setLabel(label);
        return this;
    }

    /**
     * <p>
     * When used in <code>GetMetricData</code>, this option indicates whether to return the timestamps and raw data
     * values of this metric. If you are performing this call just to do math expressions and do not also need the raw
     * data returned, you can specify <code>false</code>. If you omit this, the default of <code>true</code> is used.
     * </p>
     * <p>
     * When used in <code>PutMetricAlarm</code>, specify <code>true</code> for the one expression result to use as the
     * alarm. For all other metrics and expressions in the same <code>PutMetricAlarm</code> operation, specify
     * <code>ReturnData</code> as False.
     * </p>
     * 
     * @param returnData
     *        When used in <code>GetMetricData</code>, this option indicates whether to return the timestamps and raw
     *        data values of this metric. If you are performing this call just to do math expressions and do not also
     *        need the raw data returned, you can specify <code>false</code>. If you omit this, the default of
     *        <code>true</code> is used.</p>
     *        <p>
     *        When used in <code>PutMetricAlarm</code>, specify <code>true</code> for the one expression result to use
     *        as the alarm. For all other metrics and expressions in the same <code>PutMetricAlarm</code> operation,
     *        specify <code>ReturnData</code> as False.
     */

    public void setReturnData(Boolean returnData) {
        this.returnData = returnData;
    }

    /**
     * <p>
     * When used in <code>GetMetricData</code>, this option indicates whether to return the timestamps and raw data
     * values of this metric. If you are performing this call just to do math expressions and do not also need the raw
     * data returned, you can specify <code>false</code>. If you omit this, the default of <code>true</code> is used.
     * </p>
     * <p>
     * When used in <code>PutMetricAlarm</code>, specify <code>true</code> for the one expression result to use as the
     * alarm. For all other metrics and expressions in the same <code>PutMetricAlarm</code> operation, specify
     * <code>ReturnData</code> as False.
     * </p>
     * 
     * @return When used in <code>GetMetricData</code>, this option indicates whether to return the timestamps and raw
     *         data values of this metric. If you are performing this call just to do math expressions and do not also
     *         need the raw data returned, you can specify <code>false</code>. If you omit this, the default of
     *         <code>true</code> is used.</p>
     *         <p>
     *         When used in <code>PutMetricAlarm</code>, specify <code>true</code> for the one expression result to use
     *         as the alarm. For all other metrics and expressions in the same <code>PutMetricAlarm</code> operation,
     *         specify <code>ReturnData</code> as False.
     */

    public Boolean getReturnData() {
        return this.returnData;
    }

    /**
     * <p>
     * When used in <code>GetMetricData</code>, this option indicates whether to return the timestamps and raw data
     * values of this metric. If you are performing this call just to do math expressions and do not also need the raw
     * data returned, you can specify <code>false</code>. If you omit this, the default of <code>true</code> is used.
     * </p>
     * <p>
     * When used in <code>PutMetricAlarm</code>, specify <code>true</code> for the one expression result to use as the
     * alarm. For all other metrics and expressions in the same <code>PutMetricAlarm</code> operation, specify
     * <code>ReturnData</code> as False.
     * </p>
     * 
     * @param returnData
     *        When used in <code>GetMetricData</code>, this option indicates whether to return the timestamps and raw
     *        data values of this metric. If you are performing this call just to do math expressions and do not also
     *        need the raw data returned, you can specify <code>false</code>. If you omit this, the default of
     *        <code>true</code> is used.</p>
     *        <p>
     *        When used in <code>PutMetricAlarm</code>, specify <code>true</code> for the one expression result to use
     *        as the alarm. For all other metrics and expressions in the same <code>PutMetricAlarm</code> operation,
     *        specify <code>ReturnData</code> as False.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MetricDataQuery withReturnData(Boolean returnData) {
        setReturnData(returnData);
        return this;
    }

    /**
     * <p>
     * When used in <code>GetMetricData</code>, this option indicates whether to return the timestamps and raw data
     * values of this metric. If you are performing this call just to do math expressions and do not also need the raw
     * data returned, you can specify <code>false</code>. If you omit this, the default of <code>true</code> is used.
     * </p>
     * <p>
     * When used in <code>PutMetricAlarm</code>, specify <code>true</code> for the one expression result to use as the
     * alarm. For all other metrics and expressions in the same <code>PutMetricAlarm</code> operation, specify
     * <code>ReturnData</code> as False.
     * </p>
     * 
     * @return When used in <code>GetMetricData</code>, this option indicates whether to return the timestamps and raw
     *         data values of this metric. If you are performing this call just to do math expressions and do not also
     *         need the raw data returned, you can specify <code>false</code>. If you omit this, the default of
     *         <code>true</code> is used.</p>
     *         <p>
     *         When used in <code>PutMetricAlarm</code>, specify <code>true</code> for the one expression result to use
     *         as the alarm. For all other metrics and expressions in the same <code>PutMetricAlarm</code> operation,
     *         specify <code>ReturnData</code> as False.
     */

    public Boolean isReturnData() {
        return this.returnData;
    }

    /**
     * <p>
     * The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can be as
     * short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at
     * intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution
     * metrics are those metrics stored by a <code>PutMetricData</code> operation that includes a
     * <code>StorageResolution of 1 second</code>.
     * </p>
     * 
     * @param period
     *        The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period
     *        can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that
     *        are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of
     *        60. High-resolution metrics are those metrics stored by a <code>PutMetricData</code> operation that
     *        includes a <code>StorageResolution of 1 second</code>.
     */

    public void setPeriod(Integer period) {
        this.period = period;
    }

    /**
     * <p>
     * The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can be as
     * short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at
     * intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution
     * metrics are those metrics stored by a <code>PutMetricData</code> operation that includes a
     * <code>StorageResolution of 1 second</code>.
     * </p>
     * 
     * @return The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period
     *         can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that
     *         are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple
     *         of 60. High-resolution metrics are those metrics stored by a <code>PutMetricData</code> operation that
     *         includes a <code>StorageResolution of 1 second</code>.
     */

    public Integer getPeriod() {
        return this.period;
    }

    /**
     * <p>
     * The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period can be as
     * short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that are collected at
     * intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of 60. High-resolution
     * metrics are those metrics stored by a <code>PutMetricData</code> operation that includes a
     * <code>StorageResolution of 1 second</code>.
     * </p>
     * 
     * @param period
     *        The granularity, in seconds, of the returned data points. For metrics with regular resolution, a period
     *        can be as short as one minute (60 seconds) and must be a multiple of 60. For high-resolution metrics that
     *        are collected at intervals of less than one minute, the period can be 1, 5, 10, 30, 60, or any multiple of
     *        60. High-resolution metrics are those metrics stored by a <code>PutMetricData</code> operation that
     *        includes a <code>StorageResolution of 1 second</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MetricDataQuery withPeriod(Integer period) {
        setPeriod(period);
        return this;
    }

    /**
     * <p>
     * The ID of the account where the metrics are located.
     * </p>
     * <p>
     * If you are performing a <code>GetMetricData</code> operation in a monitoring account, use this to specify which
     * account to retrieve this metric from.
     * </p>
     * <p>
     * If you are performing a <code>PutMetricAlarm</code> operation, use this to specify which account contains the
     * metric that the alarm is watching.
     * </p>
     * 
     * @param accountId
     *        The ID of the account where the metrics are located.</p>
     *        <p>
     *        If you are performing a <code>GetMetricData</code> operation in a monitoring account, use this to specify
     *        which account to retrieve this metric from.
     *        </p>
     *        <p>
     *        If you are performing a <code>PutMetricAlarm</code> operation, use this to specify which account contains
     *        the metric that the alarm is watching.
     */

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    /**
     * <p>
     * The ID of the account where the metrics are located.
     * </p>
     * <p>
     * If you are performing a <code>GetMetricData</code> operation in a monitoring account, use this to specify which
     * account to retrieve this metric from.
     * </p>
     * <p>
     * If you are performing a <code>PutMetricAlarm</code> operation, use this to specify which account contains the
     * metric that the alarm is watching.
     * </p>
     * 
     * @return The ID of the account where the metrics are located.</p>
     *         <p>
     *         If you are performing a <code>GetMetricData</code> operation in a monitoring account, use this to specify
     *         which account to retrieve this metric from.
     *         </p>
     *         <p>
     *         If you are performing a <code>PutMetricAlarm</code> operation, use this to specify which account contains
     *         the metric that the alarm is watching.
     */

    public String getAccountId() {
        return this.accountId;
    }

    /**
     * <p>
     * The ID of the account where the metrics are located.
     * </p>
     * <p>
     * If you are performing a <code>GetMetricData</code> operation in a monitoring account, use this to specify which
     * account to retrieve this metric from.
     * </p>
     * <p>
     * If you are performing a <code>PutMetricAlarm</code> operation, use this to specify which account contains the
     * metric that the alarm is watching.
     * </p>
     * 
     * @param accountId
     *        The ID of the account where the metrics are located.</p>
     *        <p>
     *        If you are performing a <code>GetMetricData</code> operation in a monitoring account, use this to specify
     *        which account to retrieve this metric from.
     *        </p>
     *        <p>
     *        If you are performing a <code>PutMetricAlarm</code> operation, use this to specify which account contains
     *        the metric that the alarm is watching.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public MetricDataQuery withAccountId(String accountId) {
        setAccountId(accountId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getId() != null)
            sb.append("Id: ").append(getId()).append(",");
        if (getMetricStat() != null)
            sb.append("MetricStat: ").append(getMetricStat()).append(",");
        if (getExpression() != null)
            sb.append("Expression: ").append(getExpression()).append(",");
        if (getLabel() != null)
            sb.append("Label: ").append(getLabel()).append(",");
        if (getReturnData() != null)
            sb.append("ReturnData: ").append(getReturnData()).append(",");
        if (getPeriod() != null)
            sb.append("Period: ").append(getPeriod()).append(",");
        if (getAccountId() != null)
            sb.append("AccountId: ").append(getAccountId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof MetricDataQuery == false)
            return false;
        MetricDataQuery other = (MetricDataQuery) obj;
        if (other.getId() == null ^ this.getId() == null)
            return false;
        if (other.getId() != null && other.getId().equals(this.getId()) == false)
            return false;
        if (other.getMetricStat() == null ^ this.getMetricStat() == null)
            return false;
        if (other.getMetricStat() != null && other.getMetricStat().equals(this.getMetricStat()) == false)
            return false;
        if (other.getExpression() == null ^ this.getExpression() == null)
            return false;
        if (other.getExpression() != null && other.getExpression().equals(this.getExpression()) == false)
            return false;
        if (other.getLabel() == null ^ this.getLabel() == null)
            return false;
        if (other.getLabel() != null && other.getLabel().equals(this.getLabel()) == false)
            return false;
        if (other.getReturnData() == null ^ this.getReturnData() == null)
            return false;
        if (other.getReturnData() != null && other.getReturnData().equals(this.getReturnData()) == false)
            return false;
        if (other.getPeriod() == null ^ this.getPeriod() == null)
            return false;
        if (other.getPeriod() != null && other.getPeriod().equals(this.getPeriod()) == false)
            return false;
        if (other.getAccountId() == null ^ this.getAccountId() == null)
            return false;
        if (other.getAccountId() != null && other.getAccountId().equals(this.getAccountId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getId() == null) ? 0 : getId().hashCode());
        hashCode = prime * hashCode + ((getMetricStat() == null) ? 0 : getMetricStat().hashCode());
        hashCode = prime * hashCode + ((getExpression() == null) ? 0 : getExpression().hashCode());
        hashCode = prime * hashCode + ((getLabel() == null) ? 0 : getLabel().hashCode());
        hashCode = prime * hashCode + ((getReturnData() == null) ? 0 : getReturnData().hashCode());
        hashCode = prime * hashCode + ((getPeriod() == null) ? 0 : getPeriod().hashCode());
        hashCode = prime * hashCode + ((getAccountId() == null) ? 0 : getAccountId().hashCode());
        return hashCode;
    }

    @Override
    public MetricDataQuery clone() {
        try {
            return (MetricDataQuery) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
