/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.DeleteDashboardsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteDashboardsRequestMarshaller
implements Marshaller<Request<DeleteDashboardsRequest>, DeleteDashboardsRequest> {
    public Request<DeleteDashboardsRequest> marshall(DeleteDashboardsRequest deleteDashboardsRequest) {
        if (deleteDashboardsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteDashboardsRequest, "AmazonCloudWatch");
        request.addParameter("Action", "DeleteDashboards");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (!deleteDashboardsRequest.getDashboardNames().isEmpty() || !((SdkInternalList)deleteDashboardsRequest.getDashboardNames()).isAutoConstruct()) {
            SdkInternalList dashboardNamesList = (SdkInternalList)deleteDashboardsRequest.getDashboardNames();
            int dashboardNamesListIndex = 1;
            for (String dashboardNamesListValue : dashboardNamesList) {
                if (dashboardNamesListValue != null) {
                    request.addParameter("DashboardNames.member." + dashboardNamesListIndex, StringUtils.fromString((String)dashboardNamesListValue));
                }
                ++dashboardNamesListIndex;
            }
        }
        return request;
    }
}

