/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatch.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudwatch.model.Datapoint;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class GetMetricStatisticsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String label;
    private SdkInternalList<Datapoint> datapoints;

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public GetMetricStatisticsResult withLabel(String label) {
        this.setLabel(label);
        return this;
    }

    public List<Datapoint> getDatapoints() {
        if (this.datapoints == null) {
            this.datapoints = new SdkInternalList();
        }
        return this.datapoints;
    }

    public void setDatapoints(Collection<Datapoint> datapoints) {
        if (datapoints == null) {
            this.datapoints = null;
            return;
        }
        this.datapoints = new SdkInternalList(datapoints);
    }

    public GetMetricStatisticsResult withDatapoints(Datapoint ... datapoints) {
        if (this.datapoints == null) {
            this.setDatapoints((Collection<Datapoint>)new SdkInternalList(datapoints.length));
        }
        for (Datapoint ele : datapoints) {
            this.datapoints.add((Object)ele);
        }
        return this;
    }

    public GetMetricStatisticsResult withDatapoints(Collection<Datapoint> datapoints) {
        this.setDatapoints(datapoints);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLabel() != null) {
            sb.append("Label: ").append(this.getLabel()).append(",");
        }
        if (this.getDatapoints() != null) {
            sb.append("Datapoints: ").append(this.getDatapoints());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricStatisticsResult)) {
            return false;
        }
        GetMetricStatisticsResult other = (GetMetricStatisticsResult)obj;
        if (other.getLabel() == null ^ this.getLabel() == null) {
            return false;
        }
        if (other.getLabel() != null && !other.getLabel().equals(this.getLabel())) {
            return false;
        }
        if (other.getDatapoints() == null ^ this.getDatapoints() == null) {
            return false;
        }
        return other.getDatapoints() == null || other.getDatapoints().equals(this.getDatapoints());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLabel() == null ? 0 : this.getLabel().hashCode());
        hashCode = 31 * hashCode + (this.getDatapoints() == null ? 0 : this.getDatapoints().hashCode());
        return hashCode;
    }

    public GetMetricStatisticsResult clone() {
        try {
            return (GetMetricStatisticsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

