/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtraildata.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cloudtraildata.model.AuditEvent;

@SdkInternalApi
public class AuditEventMarshaller {
    private static final MarshallingInfo<String> EVENTDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventData").build();
    private static final MarshallingInfo<String> EVENTDATACHECKSUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventDataChecksum").build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final AuditEventMarshaller instance = new AuditEventMarshaller();

    public static AuditEventMarshaller getInstance() {
        return instance;
    }

    public void marshall(AuditEvent auditEvent, ProtocolMarshaller protocolMarshaller) {
        if (auditEvent == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)auditEvent.getEventData(), EVENTDATA_BINDING);
            protocolMarshaller.marshall((Object)auditEvent.getEventDataChecksum(), EVENTDATACHECKSUM_BINDING);
            protocolMarshaller.marshall((Object)auditEvent.getId(), ID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

