/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cloudtrail.model.LookupAttribute;
import com.amazonaws.services.cloudtrail.model.LookupEventsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class LookupEventsRequestMarshaller
implements Marshaller<Request<LookupEventsRequest>, LookupEventsRequest> {
    public Request<LookupEventsRequest> marshall(LookupEventsRequest lookupEventsRequest) {
        if (lookupEventsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)lookupEventsRequest, "AWSCloudTrail");
        String target = "CloudTrail_20131101.LookupEvents";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            ListWithAutoConstructFlag lookupAttributesList = (ListWithAutoConstructFlag)lookupEventsRequest.getLookupAttributes();
            if (!(lookupAttributesList == null || lookupAttributesList.isAutoConstruct() && lookupAttributesList.isEmpty())) {
                jsonWriter.key("LookupAttributes");
                jsonWriter.array();
                for (LookupAttribute lookupAttributesListValue : lookupAttributesList) {
                    if (lookupAttributesListValue == null) continue;
                    jsonWriter.object();
                    if (lookupAttributesListValue.getAttributeKey() != null) {
                        jsonWriter.key("AttributeKey").value((Object)lookupAttributesListValue.getAttributeKey());
                    }
                    if (lookupAttributesListValue.getAttributeValue() != null) {
                        jsonWriter.key("AttributeValue").value((Object)lookupAttributesListValue.getAttributeValue());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (lookupEventsRequest.getStartTime() != null) {
                jsonWriter.key("StartTime").value(lookupEventsRequest.getStartTime());
            }
            if (lookupEventsRequest.getEndTime() != null) {
                jsonWriter.key("EndTime").value(lookupEventsRequest.getEndTime());
            }
            if (lookupEventsRequest.getMaxResults() != null) {
                jsonWriter.key("MaxResults").value((Object)lookupEventsRequest.getMaxResults());
            }
            if (lookupEventsRequest.getNextToken() != null) {
                jsonWriter.key("NextToken").value((Object)lookupEventsRequest.getNextToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

