/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cloudtrail.model.Event;
import com.amazonaws.services.cloudtrail.model.Resource;
import com.amazonaws.services.cloudtrail.model.transform.ResourceJsonMarshaller;

public class EventJsonMarshaller {
    private static EventJsonMarshaller instance;

    public void marshall(Event event, StructuredJsonGenerator jsonGenerator) {
        if (event == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList resourcesList;
            jsonGenerator.writeStartObject();
            if (event.getEventId() != null) {
                jsonGenerator.writeFieldName("EventId").writeValue(event.getEventId());
            }
            if (event.getEventName() != null) {
                jsonGenerator.writeFieldName("EventName").writeValue(event.getEventName());
            }
            if (event.getEventTime() != null) {
                jsonGenerator.writeFieldName("EventTime").writeValue(event.getEventTime());
            }
            if (event.getUsername() != null) {
                jsonGenerator.writeFieldName("Username").writeValue(event.getUsername());
            }
            if (!(resourcesList = (SdkInternalList)event.getResources()).isEmpty() || !resourcesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Resources");
                jsonGenerator.writeStartArray();
                for (Resource resourcesListValue : resourcesList) {
                    if (resourcesListValue == null) continue;
                    ResourceJsonMarshaller.getInstance().marshall(resourcesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (event.getCloudTrailEvent() != null) {
                jsonGenerator.writeFieldName("CloudTrailEvent").writeValue(event.getCloudTrailEvent());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EventJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EventJsonMarshaller();
        }
        return instance;
    }
}

