/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudtrail;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.cloudtrail.AWSCloudTrail;
import com.amazonaws.services.cloudtrail.model.AddTagsRequest;
import com.amazonaws.services.cloudtrail.model.AddTagsResult;
import com.amazonaws.services.cloudtrail.model.CreateTrailRequest;
import com.amazonaws.services.cloudtrail.model.CreateTrailResult;
import com.amazonaws.services.cloudtrail.model.DeleteTrailRequest;
import com.amazonaws.services.cloudtrail.model.DeleteTrailResult;
import com.amazonaws.services.cloudtrail.model.DescribeTrailsRequest;
import com.amazonaws.services.cloudtrail.model.DescribeTrailsResult;
import com.amazonaws.services.cloudtrail.model.GetTrailStatusRequest;
import com.amazonaws.services.cloudtrail.model.GetTrailStatusResult;
import com.amazonaws.services.cloudtrail.model.ListPublicKeysRequest;
import com.amazonaws.services.cloudtrail.model.ListPublicKeysResult;
import com.amazonaws.services.cloudtrail.model.ListTagsRequest;
import com.amazonaws.services.cloudtrail.model.ListTagsResult;
import com.amazonaws.services.cloudtrail.model.LookupEventsRequest;
import com.amazonaws.services.cloudtrail.model.LookupEventsResult;
import com.amazonaws.services.cloudtrail.model.RemoveTagsRequest;
import com.amazonaws.services.cloudtrail.model.RemoveTagsResult;
import com.amazonaws.services.cloudtrail.model.StartLoggingRequest;
import com.amazonaws.services.cloudtrail.model.StartLoggingResult;
import com.amazonaws.services.cloudtrail.model.StopLoggingRequest;
import com.amazonaws.services.cloudtrail.model.StopLoggingResult;
import com.amazonaws.services.cloudtrail.model.UpdateTrailRequest;
import com.amazonaws.services.cloudtrail.model.UpdateTrailResult;
import com.amazonaws.services.cloudtrail.model.transform.AddTagsRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.AddTagsResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.CloudTrailARNInvalidExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.CloudWatchLogsDeliveryUnavailableExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.CreateTrailRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.CreateTrailResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.DeleteTrailRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.DeleteTrailResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.DescribeTrailsRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.DescribeTrailsResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.GetTrailStatusRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.GetTrailStatusResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InsufficientEncryptionPolicyExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InsufficientS3BucketPolicyExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InsufficientSnsTopicPolicyExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidCloudWatchLogsLogGroupArnExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidCloudWatchLogsRoleArnExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidKmsKeyIdExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidLookupAttributesExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidMaxResultsExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidNextTokenExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidS3BucketNameExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidS3PrefixExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidSnsTopicNameExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidTagParameterExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidTimeRangeExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidTokenExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.InvalidTrailNameExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.KmsKeyDisabledExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.KmsKeyNotFoundExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.ListPublicKeysRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.ListPublicKeysResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.ListTagsRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.ListTagsResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.LookupEventsRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.LookupEventsResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.MaximumNumberOfTrailsExceededExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.OperationNotPermittedExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.RemoveTagsRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.RemoveTagsResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.ResourceTypeNotSupportedExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.S3BucketDoesNotExistExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.StartLoggingRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.StartLoggingResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.StopLoggingRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.StopLoggingResultJsonUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.TagsLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.TrailAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.TrailNotFoundExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.TrailNotProvidedExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.UnsupportedOperationExceptionUnmarshaller;
import com.amazonaws.services.cloudtrail.model.transform.UpdateTrailRequestMarshaller;
import com.amazonaws.services.cloudtrail.model.transform.UpdateTrailResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AWSCloudTrailClient
extends AmazonWebServiceClient
implements AWSCloudTrail {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSCloudTrail.class);
    protected List<JsonErrorUnmarshaller> jsonErrorUnmarshallers;

    public AWSCloudTrailClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AWSCloudTrailClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSCloudTrailClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AWSCloudTrailClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(AWSCloudTrailClient.adjustClientConfiguration(clientConfiguration));
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSCloudTrailClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AWSCloudTrailClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AWSCloudTrailClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(AWSCloudTrailClient.adjustClientConfiguration(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();
        this.jsonErrorUnmarshallers.add(new TrailAlreadyExistsExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new KmsKeyDisabledExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new TrailNotProvidedExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new UnsupportedOperationExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new KmsKeyNotFoundExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidMaxResultsExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidS3PrefixExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidTokenExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InsufficientSnsTopicPolicyExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new TrailNotFoundExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new TagsLimitExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidTrailNameExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InsufficientEncryptionPolicyExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidCloudWatchLogsLogGroupArnExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ResourceTypeNotSupportedExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidNextTokenExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidLookupAttributesExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InsufficientS3BucketPolicyExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidTagParameterExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidS3BucketNameExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidSnsTopicNameExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new CloudTrailARNInvalidExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new MaximumNumberOfTrailsExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new CloudWatchLogsDeliveryUnavailableExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new OperationNotPermittedExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidTimeRangeExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ResourceNotFoundExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new S3BucketDoesNotExistExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidCloudWatchLogsRoleArnExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new InvalidKmsKeyIdExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("cloudtrail.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cloudtrail/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/cloudtrail/request.handler2s"));
    }

    private static ClientConfiguration adjustClientConfiguration(ClientConfiguration orig) {
        ClientConfiguration config = orig;
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsResult listTags(ListTagsRequest listTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsRequestMarshaller().marshall((ListTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListTagsResultJsonUnmarshaller unmarshaller = new ListTagsResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListTagsResult listTagsResult = (ListTagsResult)response.getAwsResponse();
            return listTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTrailStatusResult getTrailStatus(GetTrailStatusRequest getTrailStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTrailStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTrailStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTrailStatusRequestMarshaller().marshall((GetTrailStatusRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTrailStatusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetTrailStatusResultJsonUnmarshaller unmarshaller = new GetTrailStatusResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetTrailStatusResult getTrailStatusResult = (GetTrailStatusResult)response.getAwsResponse();
            return getTrailStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveTagsResult removeTags(RemoveTagsRequest removeTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removeTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemoveTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemoveTagsRequestMarshaller().marshall((RemoveTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)removeTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            RemoveTagsResultJsonUnmarshaller unmarshaller = new RemoveTagsResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            RemoveTagsResult removeTagsResult = (RemoveTagsResult)response.getAwsResponse();
            return removeTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTrailResult deleteTrail(DeleteTrailRequest deleteTrailRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTrailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTrailRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTrailRequestMarshaller().marshall((DeleteTrailRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteTrailRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeleteTrailResultJsonUnmarshaller unmarshaller = new DeleteTrailResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteTrailResult deleteTrailResult = (DeleteTrailResult)response.getAwsResponse();
            return deleteTrailResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LookupEventsResult lookupEvents(LookupEventsRequest lookupEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(lookupEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<LookupEventsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new LookupEventsRequestMarshaller().marshall((LookupEventsRequest)super.beforeMarshalling((AmazonWebServiceRequest)lookupEventsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            LookupEventsResultJsonUnmarshaller unmarshaller = new LookupEventsResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            LookupEventsResult lookupEventsResult = (LookupEventsResult)response.getAwsResponse();
            return lookupEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTrailResult createTrail(CreateTrailRequest createTrailRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createTrailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateTrailRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateTrailRequestMarshaller().marshall((CreateTrailRequest)super.beforeMarshalling((AmazonWebServiceRequest)createTrailRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateTrailResultJsonUnmarshaller unmarshaller = new CreateTrailResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateTrailResult createTrailResult = (CreateTrailResult)response.getAwsResponse();
            return createTrailResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTrailResult updateTrail(UpdateTrailRequest updateTrailRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateTrailRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateTrailRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateTrailRequestMarshaller().marshall((UpdateTrailRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateTrailRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UpdateTrailResultJsonUnmarshaller unmarshaller = new UpdateTrailResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UpdateTrailResult updateTrailResult = (UpdateTrailResult)response.getAwsResponse();
            return updateTrailResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopLoggingResult stopLogging(StopLoggingRequest stopLoggingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopLoggingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopLoggingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopLoggingRequestMarshaller().marshall((StopLoggingRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopLoggingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StopLoggingResultJsonUnmarshaller unmarshaller = new StopLoggingResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            StopLoggingResult stopLoggingResult = (StopLoggingResult)response.getAwsResponse();
            return stopLoggingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTrailsResult describeTrails(DescribeTrailsRequest describeTrailsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeTrailsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeTrailsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeTrailsRequestMarshaller().marshall((DescribeTrailsRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeTrailsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeTrailsResultJsonUnmarshaller unmarshaller = new DescribeTrailsResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeTrailsResult describeTrailsResult = (DescribeTrailsResult)response.getAwsResponse();
            return describeTrailsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPublicKeysResult listPublicKeys(ListPublicKeysRequest listPublicKeysRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPublicKeysRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPublicKeysRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPublicKeysRequestMarshaller().marshall((ListPublicKeysRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPublicKeysRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListPublicKeysResultJsonUnmarshaller unmarshaller = new ListPublicKeysResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListPublicKeysResult listPublicKeysResult = (ListPublicKeysResult)response.getAwsResponse();
            return listPublicKeysResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddTagsResult addTags(AddTagsRequest addTagsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addTagsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddTagsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddTagsRequestMarshaller().marshall((AddTagsRequest)super.beforeMarshalling((AmazonWebServiceRequest)addTagsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            AddTagsResultJsonUnmarshaller unmarshaller = new AddTagsResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            AddTagsResult addTagsResult = (AddTagsResult)response.getAwsResponse();
            return addTagsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartLoggingResult startLogging(StartLoggingRequest startLoggingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startLoggingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartLoggingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartLoggingRequestMarshaller().marshall((StartLoggingRequest)super.beforeMarshalling((AmazonWebServiceRequest)startLoggingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            StartLoggingResultJsonUnmarshaller unmarshaller = new StartLoggingResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            StartLoggingResult startLoggingResult = (StartLoggingResult)response.getAwsResponse();
            return startLoggingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    @Override
    public LookupEventsResult lookupEvents() throws AmazonServiceException, AmazonClientException {
        return this.lookupEvents(new LookupEventsRequest());
    }

    @Override
    public DescribeTrailsResult describeTrails() throws AmazonServiceException, AmazonClientException {
        return this.describeTrails(new DescribeTrailsRequest());
    }

    @Override
    public ListPublicKeysResult listPublicKeys() throws AmazonServiceException, AmazonClientException {
        return this.listPublicKeys(new ListPublicKeysRequest());
    }

    @Override
    public void setEndpoint(String endpoint) {
        super.setEndpoint(endpoint);
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        super.setEndpoint(endpoint, serviceName, regionId);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.jsonErrorUnmarshallers);
        Response result = this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
        return result;
    }
}

