/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudsearchdomain.model.SuggestModel;
import com.amazonaws.services.cloudsearchdomain.model.SuggestionMatch;
import com.amazonaws.services.cloudsearchdomain.model.transform.SuggestionMatchJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class SuggestModelJsonMarshaller {
    private static SuggestModelJsonMarshaller instance;

    public void marshall(SuggestModel suggestModel, StructuredJsonGenerator jsonGenerator) {
        if (suggestModel == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList suggestionsList;
            jsonGenerator.writeStartObject();
            if (suggestModel.getQuery() != null) {
                jsonGenerator.writeFieldName("query").writeValue(suggestModel.getQuery());
            }
            if (suggestModel.getFound() != null) {
                jsonGenerator.writeFieldName("found").writeValue(suggestModel.getFound().longValue());
            }
            if (!(suggestionsList = (SdkInternalList)suggestModel.getSuggestions()).isEmpty() || !suggestionsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("suggestions");
                jsonGenerator.writeStartArray();
                for (SuggestionMatch suggestionsListValue : suggestionsList) {
                    if (suggestionsListValue == null) continue;
                    SuggestionMatchJsonMarshaller.getInstance().marshall(suggestionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SuggestModelJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SuggestModelJsonMarshaller();
        }
        return instance;
    }
}

