/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchdomain.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.cloudsearchdomain.model.Bucket;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class BucketJsonMarshaller {
    private static BucketJsonMarshaller instance;

    public void marshall(Bucket bucket, StructuredJsonGenerator jsonGenerator) {
        if (bucket == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (bucket.getValue() != null) {
                jsonGenerator.writeFieldName("value").writeValue(bucket.getValue());
            }
            if (bucket.getCount() != null) {
                jsonGenerator.writeFieldName("count").writeValue(bucket.getCount().longValue());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static BucketJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new BucketJsonMarshaller();
        }
        return instance;
    }
}

