/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.cloudsearchv2.model.DescribeIndexFieldsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeIndexFieldsRequestMarshaller
implements Marshaller<Request<DescribeIndexFieldsRequest>, DescribeIndexFieldsRequest> {
    public Request<DescribeIndexFieldsRequest> marshall(DescribeIndexFieldsRequest describeIndexFieldsRequest) {
        if (describeIndexFieldsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeIndexFieldsRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DescribeIndexFields");
        request.addParameter("Version", "2013-01-01");
        if (describeIndexFieldsRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)describeIndexFieldsRequest.getDomainName()));
        }
        List<String> fieldNamesList = describeIndexFieldsRequest.getFieldNames();
        int fieldNamesListIndex = 1;
        for (String fieldNamesListValue : fieldNamesList) {
            if (fieldNamesListValue != null) {
                request.addParameter("FieldNames.member." + fieldNamesListIndex, StringUtils.fromString((String)fieldNamesListValue));
            }
            ++fieldNamesListIndex;
        }
        if (describeIndexFieldsRequest.isDeployed() != null) {
            request.addParameter("Deployed", StringUtils.fromBoolean((Boolean)describeIndexFieldsRequest.isDeployed()));
        }
        return request;
    }
}

