/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudhsmv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cloudhsmv2.model.Backup;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class BackupMarshaller {
    private static final MarshallingInfo<String> BACKUPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupId").build();
    private static final MarshallingInfo<String> BACKUPSTATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupState").build();
    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").build();
    private static final MarshallingInfo<Date> CREATETIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreateTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> COPYTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CopyTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Boolean> NEVEREXPIRES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NeverExpires").build();
    private static final MarshallingInfo<String> SOURCEREGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceRegion").build();
    private static final MarshallingInfo<String> SOURCEBACKUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceBackup").build();
    private static final MarshallingInfo<String> SOURCECLUSTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceCluster").build();
    private static final MarshallingInfo<Date> DELETETIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeleteTimestamp").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<List> TAGLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TagList").build();
    private static final MarshallingInfo<String> HSMTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HsmType").build();
    private static final MarshallingInfo<String> MODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Mode").build();
    private static final BackupMarshaller instance = new BackupMarshaller();

    public static BackupMarshaller getInstance() {
        return instance;
    }

    public void marshall(Backup backup, ProtocolMarshaller protocolMarshaller) {
        if (backup == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)backup.getBackupId(), BACKUPID_BINDING);
            protocolMarshaller.marshall((Object)backup.getBackupState(), BACKUPSTATE_BINDING);
            protocolMarshaller.marshall((Object)backup.getClusterId(), CLUSTERID_BINDING);
            protocolMarshaller.marshall((Object)backup.getCreateTimestamp(), CREATETIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)backup.getCopyTimestamp(), COPYTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)backup.getNeverExpires(), NEVEREXPIRES_BINDING);
            protocolMarshaller.marshall((Object)backup.getSourceRegion(), SOURCEREGION_BINDING);
            protocolMarshaller.marshall((Object)backup.getSourceBackup(), SOURCEBACKUP_BINDING);
            protocolMarshaller.marshall((Object)backup.getSourceCluster(), SOURCECLUSTER_BINDING);
            protocolMarshaller.marshall((Object)backup.getDeleteTimestamp(), DELETETIMESTAMP_BINDING);
            protocolMarshaller.marshall(backup.getTagList(), TAGLIST_BINDING);
            protocolMarshaller.marshall((Object)backup.getHsmType(), HSMTYPE_BINDING);
            protocolMarshaller.marshall((Object)backup.getMode(), MODE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

